/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mindmap;

import java.awt.geom.Line2D;
import znaishaded.net.sourceforge.plantuml.mindmap.SymetricalTee;

public class SymetricalTeePositioned {
    private final SymetricalTee tee;
    private double y;

    public String toString() {
        return "y=" + this.y + " " + this.tee;
    }

    public SymetricalTeePositioned(SymetricalTee tee) {
        this(tee, 0.0);
    }

    private SymetricalTeePositioned(SymetricalTee tee, double y) {
        this.tee = tee;
        this.y = y;
    }

    public void moveSoThatSegmentA1isOn(double newY) {
        double current = this.getSegmentA1().getY1();
        this.y += newY - current;
    }

    public void moveSoThatSegmentA2isOn(double newY) {
        double current = this.getSegmentA2().getY1();
        this.y += newY - current;
    }

    public void move(double delta) {
        this.y += delta;
    }

    public Line2D getSegmentA1() {
        return new Line2D.Double(0.0, this.y - this.tee.getThickness1() / 2.0, this.tee.getElongation1(), this.y - this.tee.getThickness1() / 2.0);
    }

    public Line2D getSegmentB1() {
        return new Line2D.Double(0.0, this.y + this.tee.getThickness1() / 2.0, this.tee.getElongation1(), this.y + this.tee.getThickness1() / 2.0);
    }

    public Line2D getSegmentA2() {
        return new Line2D.Double(this.tee.getElongation1(), this.y - this.tee.getThickness2() / 2.0, this.tee.getElongation1() + this.tee.getElongation2(), this.y - this.tee.getThickness2() / 2.0);
    }

    public Line2D getSegmentB2() {
        return new Line2D.Double(this.tee.getElongation1(), this.y + this.tee.getThickness2() / 2.0, this.tee.getElongation1() + this.tee.getElongation2(), this.y + this.tee.getThickness2() / 2.0);
    }

    public double getMaxX() {
        return this.tee.getElongation1() + this.tee.getElongation2();
    }

    public double getMaxY() {
        return this.y + Math.max(this.tee.getThickness1() / 2.0, this.tee.getThickness2() / 2.0);
    }

    public double getMinY() {
        return this.y - Math.max(this.tee.getThickness1() / 2.0, this.tee.getThickness2() / 2.0);
    }

    public final double getY() {
        return this.y;
    }

    public SymetricalTeePositioned getMax(SymetricalTeePositioned other) {
        if (this.tee != other.tee) {
            throw new IllegalArgumentException();
        }
        if (other.y > this.y) {
            return other;
        }
        return this;
    }
}

