/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mindmap;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.mindmap.StripeFrontier;
import znaishaded.net.sourceforge.plantuml.mindmap.SymetricalTee;
import znaishaded.net.sourceforge.plantuml.mindmap.SymetricalTeePositioned;

public class Tetris {
    private final StripeFrontier frontier = new StripeFrontier();
    private final List<SymetricalTeePositioned> elements = new ArrayList<SymetricalTeePositioned>();
    private double minY = Double.MAX_VALUE;
    private double maxY = -1.7976931348623157E308;
    private String name;

    public Tetris(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name + "(" + this.elements.size() + ")";
    }

    public void balance() {
        if (this.elements.size() == 0) {
            return;
        }
        if (this.minY != Double.MAX_VALUE) {
            throw new IllegalStateException();
        }
        for (SymetricalTeePositioned element : this.elements) {
            this.minY = Math.min(this.minY, element.getMinY());
            this.maxY = Math.max(this.maxY, element.getMaxY());
        }
        double mean = (this.minY + this.maxY) / 2.0;
        for (SymetricalTeePositioned stp : this.elements) {
            stp.move(-mean);
        }
    }

    public double getHeight() {
        if (this.elements.size() == 0) {
            return 0.0;
        }
        return this.maxY - this.minY;
    }

    public double getWidth() {
        double result = 0.0;
        for (SymetricalTeePositioned tee : this.elements) {
            result = Math.max(result, tee.getMaxX());
        }
        return result;
    }

    public void add(SymetricalTee tee) {
        if (this.frontier.isEmpty()) {
            SymetricalTeePositioned p1 = new SymetricalTeePositioned(tee);
            this.addInternal(p1);
            return;
        }
        double c1 = this.frontier.getContact(0.0, tee.getElongation1());
        double c2 = this.frontier.getContact(tee.getElongation1(), tee.getElongation1() + tee.getElongation2());
        SymetricalTeePositioned p1 = new SymetricalTeePositioned(tee);
        p1.moveSoThatSegmentA1isOn(c1);
        SymetricalTeePositioned p2 = new SymetricalTeePositioned(tee);
        p2.moveSoThatSegmentA2isOn(c2);
        SymetricalTeePositioned result = p1.getMax(p2);
        this.addInternal(result);
    }

    private void addInternal(SymetricalTeePositioned result) {
        this.elements.add(result);
        Line2D b1 = result.getSegmentB1();
        this.frontier.addSegment(b1.getX1(), b1.getX2(), b1.getY1());
        assert (b1.getY1() == b1.getY2());
        Line2D b2 = result.getSegmentB2();
        if (b2.getX1() != b2.getX2()) {
            this.frontier.addSegment(b2.getX1(), b2.getX2(), b2.getY1());
        }
        assert (b2.getY1() == b2.getY2());
    }

    public List<SymetricalTeePositioned> getElements() {
        return Collections.unmodifiableList(this.elements);
    }
}

