/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.regex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MatcherIterator;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.regex.RegexPartialMatch;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;

public abstract class RegexComposed
implements IRegex {
    private final List<IRegex> partials;
    private final AtomicReference<Pattern2> fullCached = new AtomicReference();

    protected final List<IRegex> partials() {
        return this.partials;
    }

    protected abstract String getFullSlow();

    private Pattern2 getPattern2() {
        Pattern2 result = this.fullCached.get();
        if (result == null) {
            String fullSlow = this.getFullSlow();
            result = MyPattern.cmpile(fullSlow);
            this.fullCached.set(result);
        }
        return result;
    }

    protected final boolean isCompiled() {
        return this.fullCached.get() != null;
    }

    public RegexComposed(IRegex ... partial) {
        this.partials = Collections.unmodifiableList(Arrays.asList(partial));
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        for (IRegex r : this.partials) {
            result.putAll(r.createPartialMatch(it));
        }
        return result;
    }

    @Override
    public final int count() {
        int cpt = this.getStartCount();
        for (IRegex r : this.partials) {
            cpt += r.count();
        }
        return cpt;
    }

    protected int getStartCount() {
        return 0;
    }

    @Override
    public RegexResult matcher(String s2) {
        Matcher2 matcher = this.getPattern2().matcher(s2);
        if (!matcher.find()) {
            return null;
        }
        MatcherIterator it = new MatcherIterator(matcher);
        return new RegexResult(this.createPartialMatch(it));
    }

    @Override
    public boolean match(StringLocated s2) {
        String tmp = s2.getString();
        Matcher2 matcher = this.getPattern2().matcher(tmp);
        if (matcher == null) {
            return false;
        }
        return matcher.find();
    }

    @Override
    public final String getPattern() {
        return this.getPattern2().pattern();
    }

    protected final List<IRegex> getPartials() {
        return this.partials;
    }
}

