/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.GuideLine;
import znaishaded.net.sourceforge.plantuml.utils.Direction;

public class DirectionalTextBlock
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock right;
    private final TextBlock left;
    private final TextBlock up;
    private final TextBlock down;
    private final GuideLine guideline;

    public DirectionalTextBlock(GuideLine guideline, TextBlock right, TextBlock left, TextBlock up, TextBlock down) {
        this.right = right;
        this.left = left;
        this.up = up;
        this.down = down;
        this.guideline = guideline;
    }

    @Override
    public void drawU(UGraphic ug) {
        Direction dir = this.guideline.getArrowDirection();
        switch (dir) {
            case RIGHT: {
                this.right.drawU(ug);
                break;
            }
            case LEFT: {
                this.left.drawU(ug);
                break;
            }
            case UP: {
                this.up.drawU(ug);
                break;
            }
            case DOWN: {
                this.down.drawU(ug);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.right.calculateDimension(stringBounder);
    }
}

