/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.tim.Eater;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenStack;

public class EaterFunctionCall
extends Eater {
    private final List<TValue> values = new ArrayList<TValue>();
    private final Map<String, TValue> namedArguments = new HashMap<String, TValue>();
    private final boolean isLegacyDefine;
    private final boolean unquoted;

    public EaterFunctionCall(StringLocated s2, boolean isLegacyDefine, boolean unquoted) {
        super(s2);
        this.isLegacyDefine = isLegacyDefine;
        this.unquoted = unquoted;
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        char ch;
        this.skipUntilChar('(');
        this.checkAndEatChar('(');
        this.skipSpaces();
        if (this.peekChar() == ')') {
            this.checkAndEatChar(')');
            return;
        }
        do {
            String varname;
            TValue result;
            String value;
            String read;
            this.skipSpaces();
            if (this.isLegacyDefine) {
                read = this.eatAndGetOptionalQuotedString();
                value = context.applyFunctionsAndVariables(memory, this.getLineLocation(), read);
                result = TValue.fromString(value);
                this.values.add(result);
            } else if (this.unquoted) {
                if (this.matchAffectation()) {
                    varname = this.eatAndGetVarname();
                    this.skipSpaces();
                    this.checkAndEatChar('=');
                    this.skipSpaces();
                    String read2 = this.eatAndGetOptionalQuotedString();
                    String value2 = context.applyFunctionsAndVariables(memory, this.getLineLocation(), read2);
                    TValue result2 = TValue.fromString(value2);
                    this.namedArguments.put(varname, result2);
                } else {
                    read = this.eatAndGetOptionalQuotedString();
                    value = context.applyFunctionsAndVariables(memory, this.getLineLocation(), read);
                    result = TValue.fromString(value);
                    this.values.add(result);
                }
            } else if (this.matchAffectation()) {
                varname = this.eatAndGetVarname();
                this.skipSpaces();
                this.checkAndEatChar('=');
                this.skipSpaces();
                TokenStack tokens = TokenStack.eatUntilCloseParenthesisOrComma(this).withoutSpace();
                tokens.guessFunctions();
                result = tokens.getResult(this.getLineLocation(), context, memory);
                this.namedArguments.put(varname, result);
            } else {
                TokenStack tokens = TokenStack.eatUntilCloseParenthesisOrComma(this).withoutSpace();
                tokens.guessFunctions();
                TValue result3 = tokens.getResult(this.getLineLocation(), context, memory);
                this.values.add(result3);
            }
            this.skipSpaces();
        } while ((ch = this.eatOneChar()) == ',');
        if (ch != ')') {
            if (this.unquoted) {
                throw EaterException.located("unquoted function/procedure cannot use expression.");
            }
            throw EaterException.located("call001");
        }
    }

    public final List<TValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public final Map<String, TValue> getNamedArguments() {
        return Collections.unmodifiableMap(this.namedArguments);
    }

    public final String getEndOfLine() throws EaterException {
        return this.eatAllToEnd();
    }
}

