/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingRuler;

public class Highlight {
    private final TimeTick tickFrom;
    private final TimeTick tickTo;
    private final Display caption;
    private final Colors colors;
    private final ISkinParam skinParam;

    public Highlight(ISkinParam skinParam, TimeTick tickFrom, TimeTick tickTo, Display caption, Colors colors) {
        this.tickFrom = tickFrom;
        this.tickTo = tickTo;
        this.caption = caption;
        this.colors = colors;
        this.skinParam = skinParam;
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.highlight);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private HColor getBackColor() {
        HColor result = this.colors.getColor(ColorType.BACK);
        if (result == null) {
            return this.getStyle().value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        return result;
    }

    private HColor getLineColor() {
        HColor result = this.colors.getColor(ColorType.LINE);
        if (result == null) {
            return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        return result;
    }

    private UStroke getUStroke() {
        return this.getStyle().getStroke();
    }

    public final TimeTick getTickFrom() {
        return this.tickFrom;
    }

    public final TimeTick getTickTo() {
        return this.tickTo;
    }

    public final Display getCaption() {
        return this.caption;
    }

    public TextBlock getCaption(ISkinParam skinParam) {
        FontConfiguration fc = FontConfiguration.create(skinParam, FontParam.TIMING, null);
        return this.caption.create(fc, HorizontalAlignment.LEFT, skinParam);
    }

    public void drawHighlightsBack(UGraphic ug, TimingRuler ruler, double height) {
        ug = ug.apply(HColors.none()).apply(this.getBackColor().bg());
        double start = ruler.getPosInPixel(this.getTickFrom());
        double end = ruler.getPosInPixel(this.getTickTo());
        URectangle rect = URectangle.build(end - start, height);
        ug.apply(UTranslate.dx(start)).draw(rect);
    }

    public void drawHighlightsLines(UGraphic ug, TimingRuler ruler, double height) {
        ug = ug.apply(this.getUStroke());
        ug = ug.apply(this.getLineColor());
        ULine line = ULine.vline(height);
        double start = ruler.getPosInPixel(this.getTickFrom());
        double end = ruler.getPosInPixel(this.getTickTo());
        ug.apply(UTranslate.dx(start)).draw(line);
        ug.apply(UTranslate.dx(end)).draw(line);
    }
}

