/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescriptionParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenFullDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameter;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameterList;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;

public class DoxygenDescriptionParamsParser {
    private final ComponentsRegistry componentsRegistry;
    private final ApiParameters apiParameters;
    private final DoxygenParameterList parameters;
    private final String anchorPrefix;
    private final Node node;

    private DoxygenDescriptionParamsParser(ComponentsRegistry componentsRegistry, DoxygenParameterList parameters, String anchorPrefix, Node node) {
        this.componentsRegistry = componentsRegistry;
        this.parameters = parameters;
        this.anchorPrefix = anchorPrefix;
        this.node = node;
        this.apiParameters = new ApiParameters(anchorPrefix);
    }

    public static ApiParameters parseParameters(ComponentsRegistry componentsRegistry, DoxygenParameterList parameters, String anchorPrefix, Node node) {
        DoxygenDescriptionParamsParser parser = new DoxygenDescriptionParamsParser(componentsRegistry, parameters, anchorPrefix, node);
        parser.parseXml();
        return parser.apiParameters;
    }

    private void parseXml() {
        XmlUtils.allNestedNodesStreamByName(this.node, "parameteritem").forEach(this::handleParam);
    }

    private void handleParam(Node paramItem) {
        Node nameAndType = XmlUtils.nextLevelNodeByName(paramItem, "parameternamelist");
        String name = XmlUtils.nextLevelNodeByName(nameAndType, "parametername").getTextContent();
        String typeText = XmlUtils.hasNodeByName(nameAndType, "parametertype") ? XmlUtils.nextLevelNodeByName(nameAndType, "parametertype").getTextContent() : "";
        ApiLinkedText type = this.linkedTextByName(name, typeText);
        Node descriptionNode = XmlUtils.nextLevelNodeByName(paramItem, "parameterdescription");
        DoxygenFullDescription paramDescription = DoxygenDescriptionParser.parseFull(this.componentsRegistry, this.parameters, this.anchorPrefix + "_", descriptionNode);
        this.apiParameters.add(name, type, paramDescription.getDescriptionElements().stream().map(DocElement::toMap).collect(Collectors.toList()), paramDescription.getSearchTextWithoutParameters());
    }

    private ApiLinkedText linkedTextByName(String name, String existingTypeText) {
        if (!existingTypeText.isEmpty()) {
            return new ApiLinkedText(existingTypeText);
        }
        DoxygenParameter byName = this.parameters.findByName(name);
        if (byName != null) {
            return byName.getType();
        }
        return new ApiLinkedText();
    }
}

