/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class PluginParamsOpts {
    private final String pluginId;
    private final Map<String, ?> opts;
    private final Map<String, String> renamesOldByNewName;

    PluginParamsOpts(String pluginId, Map<String, ?> opts) {
        this.pluginId = pluginId;
        this.opts = opts;
        this.renamesOldByNewName = new HashMap<String, String>();
    }

    public <E> E get(String name) {
        if (this.opts.containsKey(name)) {
            return (E)this.opts.get(name);
        }
        String nameToUse = this.renamesOldByNewName.getOrDefault(name, name);
        return (E)this.opts.get(nameToUse);
    }

    public <E> E get(String name, E defaultValue) {
        return this.has(name) ? this.get(name) : defaultValue;
    }

    public Number getNumber(String name, Number defaultValue) {
        return this.get(name, defaultValue);
    }

    public Number getNumber(String name) {
        return (Number)this.get(name);
    }

    public void assignToProps(Map<String, ?> props, String name) {
        if (this.has(name)) {
            props.put(name, this.get(name));
        }
    }

    public void assignToProps(Map<String, ?> props) {
        this.opts.keySet().forEach((? super T k) -> props.put((String)k, this.get((String)k)));
    }

    public void assignToDocElement(DocElement docElement) {
        this.opts.forEach(docElement::addProp);
    }

    public <E> List<E> getList(String name) {
        E v = this.get(name);
        if (v == null) {
            return Collections.emptyList();
        }
        if (!(v instanceof List)) {
            E casted = v;
            return Collections.singletonList(casted);
        }
        return (List)v;
    }

    public <E> Set<E> getSet(String name) {
        return new HashSet<E>(this.getList(name));
    }

    public Stream<String> getNames() {
        return this.opts.keySet().stream();
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        this.opts.forEach(consumer);
    }

    public String getString(String name) {
        Object v = this.get(name);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public String getRequiredString(String name) {
        Object v = this.get(name);
        if (v == null) {
            throw new RuntimeException("'" + name + "' is required for plugin: " + this.pluginId);
        }
        return v.toString();
    }

    public boolean has(String name) {
        if (this.opts.containsKey(name)) {
            return true;
        }
        String nameToUse = this.renamesOldByNewName.getOrDefault(name, name);
        return this.opts.containsKey(nameToUse);
    }

    public boolean isEmpty() {
        return this.opts.isEmpty();
    }

    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this.opts);
    }

    public String toString() {
        return "PluginParamsOpts{pluginId='" + this.pluginId + "', opts=" + this.opts + "}";
    }

    public void setRenamesInfo(Map<String, String> renamesNewByOldName) {
        this.renamesOldByNewName.clear();
        this.renamesOldByNewName.putAll(renamesNewByOldName);
    }
}

