/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.reveal;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.CollectionUtils;

public class SpoilerFencePlugin
implements FencePlugin {
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "spoiler";
    }

    @Override
    public FencePlugin create() {
        return new SpoilerFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser markupParser = componentsRegistry.defaultParser();
        this.parserResult = markupParser.parse(markupPath, content);
        String title = pluginParams.getOpts().get("title", "Press to reveal");
        return PluginResult.docElement("Spoiler", CollectionUtils.createMap("title", title, "content", this.parserResult.contentToListOfMaps()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.parserResult.auxiliaryFiles().stream();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.LOW.text(this.parserResult.getAllText());
    }
}

