/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.java.parser.EnumEntry;
import org.testingisdocumenting.znai.java.parser.JavaCodeUtils;
import org.testingisdocumenting.znai.java.parser.JavaField;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaMethodParam;
import org.testingisdocumenting.znai.java.parser.JavaMethodReturn;
import org.testingisdocumenting.znai.java.parser.JavaType;
import org.testingisdocumenting.znai.utils.StringUtils;
import znaishaded.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import znaishaded.com.github.javaparser.ast.body.EnumConstantDeclaration;
import znaishaded.com.github.javaparser.ast.body.EnumDeclaration;
import znaishaded.com.github.javaparser.ast.body.FieldDeclaration;
import znaishaded.com.github.javaparser.ast.body.MethodDeclaration;
import znaishaded.com.github.javaparser.ast.body.TypeDeclaration;
import znaishaded.com.github.javaparser.ast.comments.JavadocComment;
import znaishaded.com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import znaishaded.com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import znaishaded.com.github.javaparser.javadoc.Javadoc;
import znaishaded.com.github.javaparser.javadoc.JavadocBlockTag;
import znaishaded.com.github.javaparser.javadoc.description.JavadocDescription;
import znaishaded.com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import znaishaded.com.github.javaparser.javadoc.description.JavadocInlineTag;
import znaishaded.com.github.javaparser.javadoc.description.JavadocSnippet;

class JavaCodeVisitor
extends VoidVisitorAdapter<String> {
    private final List<String> lines;
    private final Map<String, JavaType> javaTypes;
    private final List<JavaMethod> javaMethods;
    private final List<EnumEntry> enumEntries;
    private final List<JavaField> javaFields;
    private String topLevelJavaDoc;
    private final ArrayDeque<String> parentNames;

    public JavaCodeVisitor(String code) {
        this.lines = Arrays.asList(code.split("\n"));
        this.javaTypes = new LinkedHashMap<String, JavaType>();
        this.javaMethods = new ArrayList<JavaMethod>();
        this.javaFields = new ArrayList<JavaField>();
        this.enumEntries = new ArrayList<EnumEntry>();
        this.parentNames = new ArrayDeque();
    }

    public boolean hasType(String typeName) {
        return this.javaTypes.containsKey(typeName);
    }

    public JavaType findTypeDetails(String typeName) {
        if (!this.javaTypes.containsKey(typeName)) {
            throw new RuntimeException("no type found: " + typeName);
        }
        return this.javaTypes.get(typeName);
    }

    public JavaMethod findMethodDetails(String methodNameWithOptionalTypes) {
        List<JavaMethod> details = this.findAllMethodDetails(methodNameWithOptionalTypes);
        if (details.isEmpty()) {
            return this.throwNoMethodFound(methodNameWithOptionalTypes);
        }
        return details.get(0);
    }

    public List<JavaMethod> findAllMethodDetails(String methodNameWithOptionalTypes) {
        String nameWithoutSpaces = methodNameWithOptionalTypes.replaceAll("\\s+", "");
        List<JavaMethod> result = this.javaMethods.stream().filter(m3 -> m3.matches(nameWithoutSpaces)).collect(Collectors.toList());
        if (result.isEmpty()) {
            this.throwNoMethodFound(methodNameWithOptionalTypes);
        }
        return result;
    }

    private JavaMethod throwNoMethodFound(String methodNameWithOptionalTypes) {
        throw new RuntimeException("no method found: <" + methodNameWithOptionalTypes + ">\nAvailable methods:\n" + this.renderAllMethods());
    }

    public List<EnumEntry> getEnumEntries() {
        return this.enumEntries;
    }

    public JavaField findFieldDetails(String fieldName) {
        return this.javaFields.stream().filter(f -> f.matches(fieldName)).findFirst().orElseThrow(() -> new RuntimeException("no field found: " + fieldName));
    }

    public String findJavaDoc(String entryName) {
        JavaField javaField = this.javaFields.stream().filter(f -> f.matches(entryName)).findFirst().orElse(null);
        if (javaField != null) {
            return javaField.getJavaDocText();
        }
        if (!this.hasMethodDetails(entryName)) {
            throw new RuntimeException("can't find method or field: " + entryName + ".\nAvailable methods:\n" + this.renderAllMethods() + "\nAvailable fields:\n" + this.renderAllFields());
        }
        return this.findMethodDetails(entryName).getJavaDocText();
    }

    public String getTopLevelJavaDoc() {
        return this.topLevelJavaDoc;
    }

    @Override
    public void visit(FieldDeclaration fieldDeclaration, String arg) {
        String javaDocText = fieldDeclaration.getJavadocComment().map(this::extractJavaDocDescription).orElse("");
        fieldDeclaration.getVariables().stream().map(vd -> vd.getName().getIdentifier()).forEach(name -> this.javaFields.add(new JavaField((List<String>)new ArrayList<String>(this.parentNames), (String)name, javaDocText)));
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, String arg) {
        this.extractTopLevelJavaDoc(classOrInterfaceDeclaration);
        this.registerType(classOrInterfaceDeclaration);
        this.parentNames.add(classOrInterfaceDeclaration.getName().getIdentifier());
        super.visit(classOrInterfaceDeclaration, arg);
        this.parentNames.removeLast();
    }

    @Override
    public void visit(EnumDeclaration enumDeclaration, String arg) {
        this.extractTopLevelJavaDoc(enumDeclaration);
        this.registerType(enumDeclaration);
        List entries = enumDeclaration.getEntries().stream().map(e -> {
            Optional<JavadocComment> javadocComment = e.getJavadocComment();
            String javaDocText = javadocComment.map(this::extractJavaDocDescription).orElse("");
            return new EnumEntry(e.getName().getIdentifier(), javaDocText, this.extractIsDeprecated((EnumConstantDeclaration)e));
        }).collect(Collectors.toList());
        this.enumEntries.addAll(entries);
        super.visit(enumDeclaration, arg);
    }

    @Override
    public void visit(MethodDeclaration methodDeclaration, String arg) {
        String name = methodDeclaration.getName().getIdentifier();
        String code = JavaCodeUtils.extractCode(this.lines, methodDeclaration);
        Optional<JavadocComment> javaDocComment = methodDeclaration.getJavadocComment();
        Javadoc javaDoc = javaDocComment.map(JavadocComment::parse).orElse(null);
        String javaDocText = javaDoc != null ? this.extractJavaDocDescription(javaDoc.getDescription()) : "";
        this.javaMethods.add(new JavaMethod(new ArrayList<String>(this.parentNames), name, StringUtils.stripIndentation(JavaCodeUtils.removeSemicolonAtEnd(code)), StringUtils.stripIndentation(JavaCodeUtils.removeSemicolonAtEnd(StringUtils.extractInsideCurlyBraces(code))), JavaCodeUtils.removeSemicolonAtEnd(JavaCodeUtils.extractSignature(code)), this.extractParams(methodDeclaration, javaDoc), this.extractReturn(methodDeclaration, javaDoc), javaDocText));
    }

    private boolean extractIsDeprecated(EnumConstantDeclaration e) {
        List<MarkerAnnotationExpr> annotationNodes = e.findAll(MarkerAnnotationExpr.class);
        return annotationNodes.stream().anyMatch(an -> an.getName().getIdentifier().equals("Deprecated"));
    }

    private String renderAllMethods() {
        return "    " + this.javaMethods.stream().map(JavaMethod::getFullNameWithoutFirstParent).collect(Collectors.joining("\n    "));
    }

    private String renderAllFields() {
        return "    " + this.javaFields.stream().map(JavaField::getFullNameWithoutFirstParent).collect(Collectors.joining("\n    "));
    }

    private String extractJavaDocDescription(JavadocComment javadocComment) {
        Javadoc javadoc = javadocComment.parse();
        JavadocDescription description = javadoc.getDescription();
        return description == null ? "" : this.extractJavaDocDescription(description);
    }

    private String extractJavaDocDescription(JavadocDescription description) {
        List elements = (List)this.getPrivateFieldValue(description, "elements");
        return elements.stream().map(this::elementToText).filter(text -> !text.isEmpty()).collect(Collectors.joining(" "));
    }

    private String elementToText(JavadocDescriptionElement el) {
        if (el instanceof JavadocSnippet) {
            String result = el.toText();
            return result.trim();
        }
        if (el instanceof JavadocInlineTag) {
            return "<code>" + this.extractTextFromInlinedTag(el).trim() + "</code>";
        }
        return el.toText();
    }

    private String extractTextFromInlinedTag(JavadocDescriptionElement el) {
        return (String)this.getPrivateFieldValue(el, "content");
    }

    private <E> E getPrivateFieldValue(Object o, String fieldName) {
        try {
            Field elementsFields = o.getClass().getDeclaredField(fieldName);
            elementsFields.setAccessible(true);
            return (E)elementsFields.get(o);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractTopLevelJavaDoc(TypeDeclaration<?> declaration) {
        if (this.topLevelJavaDoc == null) {
            Optional<JavadocComment> javadocComment = declaration.getJavadocComment();
            this.topLevelJavaDoc = javadocComment.isPresent() ? this.extractJavaDocDescription(javadocComment.get().parse().getDescription()) : "";
        }
    }

    private void registerType(TypeDeclaration<?> declaration) {
        String name = declaration.getName().getIdentifier();
        String code = JavaCodeUtils.extractCode(this.lines, declaration);
        JavaType javaType = new JavaType(name, StringUtils.stripIndentation(code), StringUtils.stripIndentation(StringUtils.extractInsideCurlyBraces(code)));
        this.javaTypes.put(name, javaType);
    }

    private boolean hasMethodDetails(String methodNameWithOptionalTypes) {
        String nameWithoutSpaces = methodNameWithOptionalTypes.replaceAll("\\s+", "");
        return this.javaMethods.stream().anyMatch(m3 -> m3.matches(nameWithoutSpaces));
    }

    private List<JavaMethodParam> extractParams(MethodDeclaration methodDeclaration, Javadoc javadoc) {
        Map<String, String> typeByName = methodDeclaration.getParameters().stream().collect(Collectors.toMap(p -> p.getName().getIdentifier(), p -> JavaCodeVisitor.eraseGenericType(p.getType().getElementType().toString())));
        List paramNames = methodDeclaration.getParameters().stream().map(p -> p.getName().getIdentifier()).collect(Collectors.toList());
        Map javaDocTextByName = javadoc != null ? javadoc.getBlockTags().stream().filter(b -> b.getType() == JavadocBlockTag.Type.PARAM).collect(Collectors.toMap(b -> b.getName().orElse(""), b -> this.extractJavaDocDescription(b.getContent()))) : Collections.emptyMap();
        return paramNames.stream().map(n -> new JavaMethodParam((String)n, (String)javaDocTextByName.get(n), (String)typeByName.get(n))).collect(Collectors.toList());
    }

    private JavaMethodReturn extractReturn(MethodDeclaration methodDeclaration, Javadoc javadoc) {
        if (javadoc == null) {
            return null;
        }
        Optional<JavadocBlockTag> returnBlock = javadoc.getBlockTags().stream().filter(b -> b.getType() == JavadocBlockTag.Type.RETURN).findFirst();
        if (!returnBlock.isPresent()) {
            return null;
        }
        return new JavaMethodReturn(methodDeclaration.getType().toString(), returnBlock.map(b -> this.extractJavaDocDescription(b.getContent())).orElse(""));
    }

    private static String eraseGenericType(String type) {
        return StringUtils.removeContentInsideBracketsInclusive(type);
    }
}

