/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.preprocessor;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.preprocessor.RegexpAndReplacement;

public class RegexpBasedPreprocessor {
    private final List<RegexpAndReplacement> replacementList;

    public RegexpBasedPreprocessor(List<RegexpAndReplacement> replacementList) {
        this.replacementList = replacementList;
    }

    public RegexpBasedPreprocessor(String csvRegexpReplacementDefinition) {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(csvRegexpReplacementDefinition, "regexp", "replacement");
        this.replacementList = tableData.getData().stream().map(row -> new RegexpAndReplacement(row.get(0).toString(), row.get(1).toString())).toList();
    }

    public String preprocess(String markdown) {
        for (RegexpAndReplacement regexpAndReplacement : this.replacementList) {
            Pattern compiled = Pattern.compile(regexpAndReplacement.regexp(), 40);
            Matcher matcher = compiled.matcher(markdown);
            if (!matcher.find()) continue;
            markdown = matcher.replaceAll(regexpAndReplacement.replacement());
        }
        return markdown;
    }
}

