/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import org.testingisdocumenting.znai.python.PythonBasedPythonParser;
import org.testingisdocumenting.znai.python.PythonClass;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonFileNameAndRelativeName;
import org.testingisdocumenting.znai.python.PythonParsedFile;
import org.testingisdocumenting.znai.python.PythonUtils;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.FileUtils;

public class Python {
    public static final Python INSTANCE = new Python();
    private final ThreadLocal<PythonBasedPythonParser> pythonParser = ThreadLocal.withInitial(PythonBasedPythonParser::new);
    private final Map<Path, FileTime> lastModifiedTimeByPath = new HashMap<Path, FileTime>();
    private final Map<Path, PythonParsedFile> parsedByPath = new HashMap<Path, PythonParsedFile>();

    public PythonClass parseClassOrGetCached(ResourcesResolver resourcesResolver, String fullyQualifiedName) {
        PythonFileNameAndRelativeName fileNameAndRelativeName = PythonUtils.findFileNameAndRelativeNameByFullyQualifiedName(resourcesResolver, fullyQualifiedName);
        PythonParsedFile parsedFile = this.parseFileOrGetCached(resourcesResolver.fullPath(fileNameAndRelativeName.getFileName()), new PythonContext(fileNameAndRelativeName.getFileName(), fileNameAndRelativeName.getPackageName()));
        return parsedFile.findClassByName(fileNameAndRelativeName.getRelativeName());
    }

    public PythonParsedFile parseFileOrGetCached(Path sourcePath, PythonContext context) {
        this.invalidateCache(sourcePath);
        PythonParsedFile cachedParsedFile = this.parsedByPath.get(sourcePath);
        if (cachedParsedFile != null) {
            return cachedParsedFile;
        }
        PythonParsedFile parsedFile = this.pythonParser.get().parse(sourcePath, context);
        this.cache(sourcePath, parsedFile);
        return parsedFile;
    }

    private void cache(Path sourcePath, PythonParsedFile parsedFile) {
        FileTime lastModifiedTime = FileUtils.getLastModifiedTime(sourcePath);
        this.lastModifiedTimeByPath.put(sourcePath, lastModifiedTime);
        this.parsedByPath.put(sourcePath, parsedFile);
    }

    private void invalidateCache(Path sourcePath) {
        FileTime lastModifiedTime = FileUtils.getLastModifiedTime(sourcePath);
        FileTime previousModifiedTime = this.lastModifiedTimeByPath.get(sourcePath);
        if (previousModifiedTime == null) {
            return;
        }
        if (!lastModifiedTime.equals(previousModifiedTime)) {
            this.lastModifiedTimeByPath.remove(sourcePath);
            this.parsedByPath.remove(sourcePath);
        }
    }
}

