/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.NameUtils;

public class TocNameAndOpts {
    private final String TITLE_KEY = "title";
    private final String givenName;
    private final Map<String, ?> opts;
    private final boolean hasTitleOverride;
    private String humanReadableName;

    public TocNameAndOpts(String trimmed) {
        int openBracketIdx = trimmed.indexOf(123);
        boolean hasOpenBracket = openBracketIdx != -1;
        this.givenName = hasOpenBracket ? trimmed.substring(0, openBracketIdx).trim() : trimmed;
        this.opts = hasOpenBracket ? this.extractOpts(trimmed, openBracketIdx) : Collections.emptyMap();
        this.hasTitleOverride = this.opts.containsKey("title");
        this.humanReadableName = this.buildHumanReadableName();
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public void setHumanReadableName(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public Map<String, ?> getOpts() {
        return this.opts;
    }

    public boolean hasTitleOverride() {
        return this.hasTitleOverride;
    }

    private Map<String, ?> extractOpts(String trimmed, int openBracketIdx) {
        int closeBracketIdx = trimmed.indexOf(125);
        if (closeBracketIdx == -1) {
            throw new IllegalArgumentException("can't find closing } for options: " + trimmed);
        }
        return JsonUtils.deserializeAsMap(trimmed.substring(openBracketIdx, closeBracketIdx + 1));
    }

    private String buildHumanReadableName() {
        Object title = this.opts.get("title");
        if (title != null) {
            return title.toString();
        }
        int dotIdx = this.givenName.indexOf(46);
        String withoutExtension = dotIdx == -1 ? this.givenName : this.givenName.substring(0, dotIdx);
        return NameUtils.dashToCamelCaseWithSpaces(withoutExtension);
    }
}

