/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.examples;

import java.io.IOException;
import java.util.UUID;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.examples.Utils;
import znaishaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import znaishaded.com.github.fge.jsonschema.format.FormatAttribute;
import znaishaded.com.github.fge.jsonschema.library.DraftV4Library;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.main.JsonSchema;
import znaishaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import znaishaded.com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;
import znaishaded.com.github.fge.msgsimple.source.MapMessageSource;
import znaishaded.com.github.fge.msgsimple.source.MessageSource;

public final class Example8 {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Utils.loadResource("/custom-fmt.json");
        JsonNode good = Utils.loadResource("/custom-fmt-good.json");
        JsonNode bad = Utils.loadResource("/custom-fmt-bad.json");
        Library library = DraftV4Library.get().thaw().addFormatAttribute("uuid", UUIDFormatAttribute.getInstance()).freeze();
        String key = "invalidUUID";
        String value = "input is not a valid UUID";
        MessageSource source = MapMessageSource.newBuilder().put("invalidUUID", "input is not a valid UUID").build();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(source).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).setValidationMessages(bundle).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
    }

    private static final class UUIDFormatAttribute
    extends AbstractFormatAttribute {
        private static final FormatAttribute INSTANCE = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super("uuid", NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return INSTANCE;
        }

        @Override
        public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
            String value = data.getInstance().getNode().textValue();
            try {
                UUID.fromString(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.newMsg(data, bundle, "invalidUUID").put("input", value));
            }
        }
    }
}

