/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.msgsimple.bundle;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import znaishaded.com.github.fge.msgsimple.InternalBundle;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.provider.LoadingMessageSourceProvider;
import znaishaded.com.github.fge.msgsimple.provider.MessageSourceLoader;
import znaishaded.com.github.fge.msgsimple.provider.MessageSourceProvider;
import znaishaded.com.github.fge.msgsimple.source.MessageSource;
import znaishaded.com.github.fge.msgsimple.source.PropertiesMessageSource;

public final class PropertiesBundle {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset ISO = Charset.forName("ISO-8859-1");
    private static final Pattern SUFFIX = Pattern.compile("\\.properties$");

    private PropertiesBundle() {
    }

    public static MessageBundle forPath(String resourcePath) {
        return PropertiesBundle.createBundle(resourcePath, UTF8, 0L, null);
    }

    public static MessageBundle forPath(String resourcePath, long duration, TimeUnit timeUnit) {
        return PropertiesBundle.createBundle(resourcePath, UTF8, duration, timeUnit);
    }

    public static MessageBundle forPath(String resourcePath, Charset charset, long duration, TimeUnit unit) {
        return PropertiesBundle.createBundle(resourcePath, charset, duration, unit);
    }

    public static MessageBundle legacyResourceBundle(String resourcePath) {
        return PropertiesBundle.createBundle(resourcePath, ISO, 0L, null);
    }

    private static MessageBundle createBundle(String resourcePath, final Charset charset, long duration, @Nullable TimeUnit unit) {
        BUNDLE.checkNotNull(resourcePath, "cfg.nullResourcePath");
        BUNDLE.checkNotNull(charset, "cfg.nullCharset");
        String s2 = resourcePath.startsWith("/") ? resourcePath : '/' + resourcePath;
        final String realPath = SUFFIX.matcher(s2).replaceFirst("");
        MessageSourceLoader loader = new MessageSourceLoader(){

            @Override
            public MessageSource load(Locale locale) throws IOException {
                StringBuilder sb = new StringBuilder(realPath);
                if (!locale.equals(Locale.ROOT)) {
                    sb.append('_').append(locale.toString());
                }
                sb.append(".properties");
                return PropertiesMessageSource.fromResource(sb.toString(), charset);
            }
        };
        LoadingMessageSourceProvider.Builder builder = LoadingMessageSourceProvider.newBuilder().setLoader(loader);
        if (duration == 0L) {
            builder.neverExpires();
        } else {
            builder.setLoadTimeout(duration, unit);
        }
        MessageSourceProvider provider = builder.build();
        return MessageBundle.newBuilder().appendProvider(provider).freeze();
    }
}

