/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.plantuml.api.cheerpj;

import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;

public class JsonResult {
    private final StringBuilder sb = new StringBuilder();

    private JsonResult(long startingTime) {
        this.sb.append("{");
        this.append("duration", System.currentTimeMillis() - startingTime);
    }

    private Object done() {
        this.sb.append("}");
        return this.sb.toString();
    }

    public static Object noDataFound(long startingTime) {
        JsonResult res = new JsonResult(startingTime);
        res.append("status", "No data found");
        return res.done();
    }

    public static Object fromCrash(long startingTime, Throwable t) {
        JsonResult res = new JsonResult(startingTime);
        res.append("status", "General failure");
        res.append("exception", t.toString());
        return res.done();
    }

    public static Object ok(long startingTime, ImageData imageData, Diagram diagram) {
        JsonResult res = new JsonResult(startingTime);
        res.append("status", "ok");
        if (imageData != null) {
            res.append("width", imageData.getWidth());
            res.append("height", imageData.getHeight());
        }
        res.append("description", diagram.getDescription().getDescription());
        return res.done();
    }

    public static Object fromError(long startingTime, PSystemError system) {
        JsonResult res = new JsonResult(startingTime);
        res.append("status", "Parsing error");
        ErrorUml err = system.getErrorsUml().iterator().next();
        res.append("line", err.getPosition());
        res.append("error", err.getError());
        return res.done();
    }

    private void append(String key, String value) {
        this.appendKeyOnly(key);
        this.sb.append('\"');
        this.sb.append(value);
        this.sb.append('\"');
    }

    private void append(String key, long value) {
        this.appendKeyOnly(key);
        this.sb.append(value);
    }

    protected void appendKeyOnly(String key) {
        if (this.sb.length() > 1) {
            this.sb.append(',');
        }
        this.sb.append('\"');
        this.sb.append(key);
        this.sb.append('\"');
        this.sb.append(':');
    }
}

