/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.jackson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import znaishaded.com.fasterxml.jackson.core.Version;
import znaishaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import znaishaded.com.fasterxml.jackson.databind.BeanDescription;
import znaishaded.com.fasterxml.jackson.databind.JavaType;
import znaishaded.com.fasterxml.jackson.databind.Module;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.PropertyName;
import znaishaded.com.fasterxml.jackson.databind.introspect.Annotated;
import znaishaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import znaishaded.com.fasterxml.jackson.databind.module.SimpleModule;
import znaishaded.io.swagger.annotations.ApiModel;
import znaishaded.io.swagger.annotations.ApiModelProperty;
import znaishaded.io.swagger.converter.ModelConverter;
import znaishaded.io.swagger.converter.ModelConverterContext;
import znaishaded.io.swagger.jackson.SwaggerAnnotationIntrospector;
import znaishaded.io.swagger.jackson.TypeNameResolver;
import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.javax.xml.bind.annotation.XmlElement;
import znaishaded.org.apache.commons.lang3.StringUtils;

public abstract class AbstractModelConverter
implements ModelConverter {
    protected final ObjectMapper _mapper;
    protected final AnnotationIntrospector _intr;
    protected final TypeNameResolver _typeNameResolver;
    protected Map<JavaType, String> _resolvedTypeNames = new ConcurrentHashMap<JavaType, String>();

    protected AbstractModelConverter(ObjectMapper mapper) {
        this(mapper, TypeNameResolver.std);
    }

    protected AbstractModelConverter(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        mapper.registerModule(new SimpleModule("swagger", Version.unknownVersion()){

            @Override
            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector(new SwaggerAnnotationIntrospector());
            }
        });
        this._mapper = mapper;
        this._typeNameResolver = typeNameResolver;
        this._intr = mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    protected static Comparator<Property> getPropertyComparator() {
        return new Comparator<Property>(){

            @Override
            public int compare(Property one, Property two) {
                if (one.getPosition() == null && two.getPosition() == null) {
                    return 0;
                }
                if (one.getPosition() == null) {
                    return -1;
                }
                if (two.getPosition() == null) {
                    return 1;
                }
                return one.getPosition().compareTo(two.getPosition());
            }
        };
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolveProperty(type, context, annotations, chain);
        }
        return null;
    }

    protected String _description(Annotated ann) {
        return this._intr.findPropertyDescription(ann);
    }

    protected String _typeName(JavaType type) {
        return this._typeName(type, null);
    }

    protected String _typeName(JavaType type, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type, beanDesc);
        this._resolvedTypeNames.put(type, name);
        return name;
    }

    protected boolean prioritizeAnnotationInspectorSchemaName() {
        return false;
    }

    protected String _findTypeName(JavaType type, BeanDescription beanDesc) {
        ApiModel model;
        if (type.isArrayType()) {
            return "Array";
        }
        if (type.isMapLikeType()) {
            return "Map";
        }
        if (type.isContainerType()) {
            if (Set.class.isAssignableFrom(type.getRawClass())) {
                return "Set";
            }
            return "List";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type);
        }
        if (!this.prioritizeAnnotationInspectorSchemaName() && (model = type.getRawClass().getAnnotation(ApiModel.class)) != null && StringUtils.isNotBlank(model.value())) {
            return this._typeNameResolver.nameForType(type, new TypeNameResolver.Options[0]);
        }
        PropertyName rootName = this._intr.findRootName(beanDesc.getClassInfo());
        if (rootName != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type, new TypeNameResolver.Options[0]);
    }

    protected String _typeQName(JavaType type) {
        return type.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type) {
        return type.getType().getName();
    }

    protected String _findDefaultValue(Annotated a) {
        XmlElement elem = a.getAnnotation(XmlElement.class);
        if (elem != null && !elem.defaultValue().isEmpty() && !"\u0000".equals(elem.defaultValue())) {
            return elem.defaultValue();
        }
        return null;
    }

    protected String _findExampleValue(Annotated a) {
        ApiModelProperty prop = a.getAnnotation(ApiModelProperty.class);
        if (prop != null && !prop.example().isEmpty()) {
            return prop.example();
        }
        return null;
    }

    protected Boolean _findReadOnly(Annotated a) {
        ApiModelProperty prop = a.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            return prop.readOnly();
        }
        return null;
    }

    protected Boolean _findReadOnlyFromAccessMode(Annotated a) {
        ApiModelProperty prop = a.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            if (prop.accessMode().equals((Object)ApiModelProperty.AccessMode.AUTO)) {
                return null;
            }
            if (prop.accessMode().equals((Object)ApiModelProperty.AccessMode.READ_ONLY)) {
                return true;
            }
            return false;
        }
        return null;
    }

    protected boolean _isSetType(Class<?> cls) {
        if (cls != null) {
            if (Set.class.equals(cls)) {
                return true;
            }
            for (Class<?> a : cls.getInterfaces()) {
                if (!Set.class.equals(a) && !"interface scala.collection.Set".equals(a.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }
}

