/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.nio.charset.Charset;
import java.util.function.Supplier;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import znaishaded.io.netty.handler.codec.http.multipart.FileUpload;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.impl.HttpServerFileUploadImpl;
import znaishaded.io.vertx.core.http.impl.NettyFileUpload;

class NettyFileUploadDataFactory
extends DefaultHttpDataFactory {
    final Context context;
    final HttpServerRequest request;
    final Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler;

    NettyFileUploadDataFactory(Context context, HttpServerRequest request, Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler) {
        super(false);
        this.context = context;
        this.request = request;
        this.lazyUploadHandler = lazyUploadHandler;
    }

    @Override
    public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        NettyFileUpload nettyUpload = new NettyFileUpload(this.context, this.request, name, filename, contentType, contentTransferEncoding, charset);
        HttpServerFileUploadImpl upload = new HttpServerFileUploadImpl(this.context, nettyUpload, name, filename, contentType, contentTransferEncoding, charset, size);
        Handler<HttpServerFileUpload> uploadHandler = this.lazyUploadHandler.get();
        if (uploadHandler != null) {
            uploadHandler.handle(upload);
        }
        return nettyUpload;
    }
}

