/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.FormLoginHandler;

public class FormLoginHandlerImpl
implements FormLoginHandler {
    private static final Logger log = LoggerFactory.getLogger(FormLoginHandlerImpl.class);
    private final AuthProvider authProvider;
    private String usernameParam;
    private String passwordParam;
    private String returnURLParam;
    private String directLoggedInOKURL;
    private static final String DEFAULT_DIRECT_LOGGED_IN_OK_PAGE = "<html><body><h1>Login successful</h1></body></html>";

    @Override
    public FormLoginHandler setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
        return this;
    }

    @Override
    public FormLoginHandler setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
        return this;
    }

    @Override
    public FormLoginHandler setReturnURLParam(String returnURLParam) {
        this.returnURLParam = returnURLParam;
        return this;
    }

    @Override
    public FormLoginHandler setDirectLoggedInOKURL(String directLoggedInOKURL) {
        this.directLoggedInOKURL = directLoggedInOKURL;
        return this;
    }

    public FormLoginHandlerImpl(AuthProvider authProvider, String usernameParam, String passwordParam, String returnURLParam, String directLoggedInOKURL) {
        this.authProvider = authProvider;
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.returnURLParam = returnURLParam;
        this.directLoggedInOKURL = directLoggedInOKURL;
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerRequest req = context.request();
        if (req.method() != HttpMethod.POST) {
            context.fail(405);
        } else {
            if (!req.isExpectMultipart()) {
                throw new IllegalStateException("HttpServerRequest should have setExpectMultipart set to true, but it is currently set to false.");
            }
            MultiMap params = req.formAttributes();
            String username = params.get(this.usernameParam);
            String password = params.get(this.passwordParam);
            if (username == null || password == null) {
                log.warn("No username or password provided in form - did you forget to include a BodyHandler?");
                context.fail(400);
            } else {
                Session session = context.session();
                JsonObject authInfo = new JsonObject().put("username", username).put("password", password);
                this.authProvider.authenticate(authInfo, res -> {
                    if (res.succeeded()) {
                        User user = (User)res.result();
                        context.setUser(user);
                        if (session != null) {
                            session.regenerateId();
                            String returnURL = (String)session.remove(this.returnURLParam);
                            if (returnURL != null) {
                                this.doRedirect(req.response(), returnURL);
                                return;
                            }
                        }
                        if (this.directLoggedInOKURL != null) {
                            this.doRedirect(req.response(), this.directLoggedInOKURL);
                        } else {
                            req.response().end(DEFAULT_DIRECT_LOGGED_IN_OK_PAGE);
                        }
                    } else {
                        context.fail(403);
                    }
                });
            }
        }
    }

    private void doRedirect(HttpServerResponse response, String url) {
        response.putHeader("location", url).setStatusCode(302).end();
    }
}

