/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionBreak;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionEnd;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionFork;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionGoto;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionGroup;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionIf;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionLabel;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionRepeat;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionSimple;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionSplit;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionSpot;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionStart;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionSwitch;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionWhile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlanes;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionMode;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionXorYBuilder;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockRecentred;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class ActivityDiagram3
extends UmlDiagram {
    private SwimlaneStrategy swimlaneStrategy;
    private final Swimlanes swinlanes = new Swimlanes(this.getSkinParam(), this.getPragma());
    private boolean hasUrl = false;

    public ActivityDiagram3(UmlSource source, Map<String, String> skinParam) {
        super(source, UmlDiagramType.ACTIVITY, skinParam);
    }

    private void manageSwimlaneStrategy() {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_FORBIDDEN;
        }
    }

    public CommandExecutionResult swimlane(String name, HColor color, Display label) {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_ALLOWED;
        }
        if (this.swimlaneStrategy == SwimlaneStrategy.SWIMLANE_FORBIDDEN) {
            return CommandExecutionResult.error("This swimlane must be defined at the start of the diagram.");
        }
        this.swinlanes.swimlane(name, color, label);
        return CommandExecutionResult.ok();
    }

    private void setCurrent(Instruction ins) {
        this.swinlanes.setCurrent(ins);
    }

    private Instruction current() {
        return this.swinlanes.getCurrent();
    }

    private LinkRendering nextLinkRenderer() {
        return this.swinlanes.nextLinkRenderer();
    }

    public CommandExecutionResult addActivity(Display activity, BoxStyle style, Url url, Colors colors, Stereotype stereotype) {
        this.manageSwimlaneStrategy();
        InstructionSimple ins = new InstructionSimple(activity, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane(), style, url, colors, stereotype);
        CommandExecutionResult added = this.current().add(ins);
        if (!added.isOk()) {
            return added;
        }
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.manageHasUrl(activity);
        if (url != null) {
            this.hasUrl = true;
        }
        return CommandExecutionResult.ok();
    }

    public void addSpot(String spot, HColor color) {
        InstructionSpot ins = new InstructionSpot(spot, color, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.manageSwimlaneStrategy();
    }

    public CommandExecutionResult addGoto(String name) {
        InstructionGoto ins = new InstructionGoto(this.swinlanes.getCurrentSwimlane(), name);
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addLabel(String name) {
        InstructionLabel ins = new InstructionLabel(this.swinlanes.getCurrentSwimlane(), name);
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public void start() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionStart(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer()));
        this.setNextLinkRendererInternal(LinkRendering.none());
    }

    public void stop() {
        this.manageSwimlaneStrategy();
        InstructionStop ins = new InstructionStop(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(ins)) {
            return;
        }
        this.current().add(ins);
    }

    public void end() {
        this.manageSwimlaneStrategy();
        InstructionEnd ins = new InstructionEnd(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(ins)) {
            return;
        }
        this.current().add(ins);
    }

    private boolean manageSpecialStopEndAfterEndWhile(Instruction special) {
        if (!(this.current() instanceof InstructionList)) {
            return false;
        }
        InstructionList current = (InstructionList)this.current();
        Instruction last = current.getLast();
        if (!(last instanceof InstructionWhile)) {
            return false;
        }
        InstructionWhile instructionWhile = (InstructionWhile)last;
        if (instructionWhile.containsBreak()) {
            return false;
        }
        instructionWhile.setSpecial(special);
        return true;
    }

    public void breakInstruction() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionBreak(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer()));
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("activity3");
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
        TextBlock result = this.getTextBlock(stringBounder);
        return this.createImageBuilder(fileFormatOption).drawable(result).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
        return this.getTextBlock(stringBounder);
    }

    private TextBlock getTextBlock(StringBounder stringBounder) {
        this.swinlanes.computeSize(stringBounder);
        TextBlock result = this.swinlanes;
        result = CompressionXorYBuilder.build(CompressionMode.ON_X, result, stringBounder);
        result = CompressionXorYBuilder.build(CompressionMode.ON_Y, result, stringBounder);
        result = new TextBlockRecentred(result);
        return result;
    }

    public void fork() {
        this.manageSwimlaneStrategy();
        InstructionFork instructionFork = new InstructionFork(this.current(), this.nextLinkRenderer(), this.getSkinParam(), this.swinlanes.getCurrentSwimlane());
        this.current().add(instructionFork);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionFork);
    }

    public CommandExecutionResult forkAgain() {
        if (this.current() instanceof InstructionFork) {
            InstructionFork currentFork = (InstructionFork)this.current();
            currentFork.manageOutRendering(this.nextLinkRenderer(), false);
            this.setNextLinkRendererInternal(LinkRendering.none());
            currentFork.forkAgain(this.swinlanes.getCurrentSwimlane());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public CommandExecutionResult endFork(ForkStyle forkStyle, String label) {
        if (this.current() instanceof InstructionFork) {
            InstructionFork currentFork = (InstructionFork)this.current();
            currentFork.setStyle(forkStyle, label, this.swinlanes.getCurrentSwimlane());
            currentFork.manageOutRendering(this.nextLinkRenderer(), true);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(currentFork.getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public void split() {
        InstructionSplit instructionSplit = new InstructionSplit(this.current(), this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.current().add(instructionSplit);
        this.setCurrent(instructionSplit);
    }

    public CommandExecutionResult splitAgain() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).splitAgain(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public CommandExecutionResult endSplit() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).endSplit(this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionSplit)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public void startSwitch(Display test2, HColor color) {
        this.manageSwimlaneStrategy();
        InstructionSwitch instructionSwitch = new InstructionSwitch(this.swinlanes.getCurrentSwimlane(), this.current(), test2, this.nextLinkRenderer(), color, this.getSkinParam());
        this.current().add(instructionSwitch);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionSwitch);
    }

    public CommandExecutionResult switchCase(Display labelCase) {
        if (this.current() instanceof InstructionSwitch) {
            boolean ok = ((InstructionSwitch)this.current()).switchCase(labelCase, this.nextLinkRenderer());
            if (!ok) {
                return CommandExecutionResult.error("You cannot put an elseIf here");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find switch");
    }

    public CommandExecutionResult endSwitch() {
        if (this.current() instanceof InstructionSwitch) {
            ((InstructionSwitch)this.current()).endSwitch(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionSwitch)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find switch");
    }

    public void startIf(Display test2, Display whenThen, HColor color, Url url) {
        this.manageSwimlaneStrategy();
        InstructionIf instructionIf = new InstructionIf(this.swinlanes.getCurrentSwimlane(), this.current(), test2, LinkRendering.none().withDisplay(whenThen), this.nextLinkRenderer(), color, this.getSkinParam(), url);
        this.current().add(instructionIf);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionIf);
    }

    public CommandExecutionResult elseIf(LinkRendering inlabel, Display test2, LinkRendering whenThen, HColor color) {
        if (this.current() instanceof InstructionIf) {
            boolean ok = ((InstructionIf)this.current()).elseIf(inlabel, test2, whenThen, this.nextLinkRenderer(), color);
            if (!ok) {
                return CommandExecutionResult.error("You cannot put an elseIf here");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult else2(LinkRendering whenElse) {
        if (this.current() instanceof InstructionIf) {
            boolean result = ((InstructionIf)this.current()).swithToElse2(whenElse, this.nextLinkRenderer());
            if (!result) {
                return CommandExecutionResult.error("Cannot find if");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult endif() {
        if (this.current() instanceof InstructionIf) {
            ((InstructionIf)this.current()).endif(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionIf)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public void startRepeat(HColor color, Display label, BoxStyle boxStyleIn, Colors colors) {
        this.manageSwimlaneStrategy();
        InstructionRepeat instructionRepeat = new InstructionRepeat(this.swinlanes, this.current(), this.nextLinkRenderer(), color, label, boxStyleIn, colors);
        this.current().add(instructionRepeat);
        this.setCurrent(instructionRepeat);
        this.setNextLinkRendererInternal(LinkRendering.none());
    }

    public CommandExecutionResult repeatWhile(Display label, Display yes, Display out, Display linkLabel, Rainbow linkColor) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            LinkRendering back = LinkRendering.create(linkColor).withDisplay(linkLabel);
            instructionRepeat.setTest(label, yes, out, this.nextLinkRenderer(), back, this.swinlanes.getCurrentSwimlane());
            this.setCurrent(instructionRepeat.getParent());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public CommandExecutionResult backward(Display label, BoxStyle boxStyle, LinkRendering incoming1, LinkRendering incoming2, Stereotype stereotype) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            instructionRepeat.setBackward(label, this.swinlanes.getCurrentSwimlane(), boxStyle, incoming1, incoming2, stereotype);
            return CommandExecutionResult.ok();
        }
        if (this.current() instanceof InstructionWhile) {
            InstructionWhile instructionWhile = (InstructionWhile)this.current();
            instructionWhile.setBackward(label, this.swinlanes.getCurrentSwimlane(), boxStyle, incoming1, incoming2);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public void doWhile(Display test2, Display yes, HColor color) {
        this.manageSwimlaneStrategy();
        InstructionWhile instructionWhile = new InstructionWhile(this.swinlanes.getCurrentSwimlane(), this.current(), test2, this.nextLinkRenderer(), yes, color, this.getSkinParam());
        this.current().add(instructionWhile);
        this.setCurrent(instructionWhile);
    }

    public CommandExecutionResult endwhile(Display out) {
        if (this.current() instanceof InstructionWhile) {
            ((InstructionWhile)this.current()).incoming(this.nextLinkRenderer());
            ((InstructionWhile)this.current()).outDisplay(out);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionWhile)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find while");
    }

    public final CommandExecutionResult kill() {
        if (!this.current().kill()) {
            return CommandExecutionResult.error("kill cannot be used here");
        }
        return CommandExecutionResult.ok();
    }

    public void startGroup(Display name, HColor backColor, USymbol type, Style style) {
        this.manageSwimlaneStrategy();
        InstructionGroup instructionGroup = new InstructionGroup(this.current(), name, backColor, this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer(), type, style);
        this.current().add(instructionGroup);
        this.setCurrent(instructionGroup);
    }

    public CommandExecutionResult endGroup() {
        if (this.current() instanceof InstructionGroup) {
            this.setCurrent(((InstructionGroup)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find group");
    }

    private void setNextLinkRendererInternal(LinkRendering link) {
        this.swinlanes.setNextLinkRenderer(Objects.requireNonNull(link));
    }

    private void setNextLink(LinkRendering linkRenderer) {
        Objects.requireNonNull(linkRenderer);
        if (this.current() instanceof InstructionCollection) {
            Instruction last = ((InstructionCollection)this.current()).getLast();
            if (last instanceof InstructionWhile) {
                ((InstructionWhile)last).outColor(linkRenderer.getRainbow());
            } else if (last instanceof InstructionIf) {
                ((InstructionIf)last).outColor(linkRenderer);
            }
        }
        this.setNextLinkRendererInternal(linkRenderer);
    }

    public void setLabelNextArrow(Display label) {
        if (this.current() instanceof InstructionWhile && ((InstructionWhile)this.current()).getLast() == null) {
            ((InstructionWhile)this.current()).overwriteYes(label);
            return;
        }
        this.setNextLinkRendererInternal(this.nextLinkRenderer().withDisplay(label));
    }

    public void setColorNextArrow(Rainbow color) {
        if (color == null) {
            return;
        }
        LinkRendering link = LinkRendering.create(color);
        this.setNextLink(link);
    }

    public CommandExecutionResult addNote(Display note, NotePosition position, NoteType type, Colors colors) {
        boolean ok = this.current().addNote(note, position, type, colors, this.swinlanes.getCurrentSwimlane());
        if (!ok) {
            return CommandExecutionResult.error("Cannot add note here");
        }
        this.manageHasUrl(note);
        return CommandExecutionResult.ok();
    }

    private void manageHasUrl(Display display) {
        if (display.hasUrl()) {
            this.hasUrl = true;
        }
    }

    @Override
    public boolean hasUrl() {
        return this.hasUrl;
    }

    static enum SwimlaneStrategy {
        SWIMLANE_FORBIDDEN,
        SWIMLANE_ALLOWED;

    }
}

