/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileDimensionMemoize;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class FtileIfNude
extends FtileDimensionMemoize {
    protected final Ftile tile1;
    protected final Ftile tile2;
    private final Swimlane in;
    protected double xDeltaNote = 0.0;
    protected double yDeltaNote = 0.0;
    protected double suppWidthNode = 0.0;

    FtileIfNude(Ftile tile1, Ftile tile2, Swimlane in) {
        super(tile1.skinParam());
        this.tile1 = tile1;
        this.tile2 = tile2;
        this.in = in;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.tile1, this.tile2);
    }

    public boolean hasTwoBranches(StringBounder stringBounder) {
        return this.tile1.calculateDimension(stringBounder).hasPointOut() && this.tile2.calculateDimension(stringBounder).hasPointOut();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.in;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    protected UTranslate getTranslateBranch1(StringBounder stringBounder) {
        double x1 = this.xDeltaNote;
        double y1 = this.yDeltaNote;
        return new UTranslate(x1, y1);
    }

    protected UTranslate getTranslateBranch2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = ((XDimension2D)dimTotal).getWidth() - ((XDimension2D)dim2).getWidth() - this.suppWidthNode;
        double y2 = this.yDeltaNote;
        return new UTranslate(x2, y2);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile1) {
            return this.getTranslateBranch1(stringBounder);
        }
        if (child == this.tile2) {
            return this.getTranslateBranch2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateBranch1(stringBounder)).draw(this.tile1);
        ug.apply(this.getTranslateBranch2(stringBounder)).draw(this.tile2);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        if (this.tile1.calculateDimension(stringBounder).hasPointOut() || this.tile2.calculateDimension(stringBounder).hasPointOut()) {
            return dimTotal;
        }
        return dimTotal.withoutPointOut();
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double innerMargin = this.widthInner(stringBounder);
        double width = this.xDeltaNote + dim1.getLeft() + innerMargin + (dim2.getWidth() - dim2.getLeft()) + this.suppWidthNode;
        XDimension2D dim12 = dim1.mergeLR(dim2);
        double height = this.yDeltaNote + dim12.getHeight();
        return new FtileGeometry(width, height, this.xDeltaNote + dim1.getLeft() + innerMargin / 2.0, this.yDeltaNote, height);
    }

    protected double widthInner(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        return dim1.getWidth() - dim1.getLeft() + dim2.getLeft();
    }
}

