/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import znaishaded.net.sourceforge.plantuml.code.ByteArray;
import znaishaded.net.sourceforge.plantuml.code.Compression;
import znaishaded.net.sourceforge.plantuml.code.NoPlantumlCompressionException;

public class CompressionZip
implements Compression {
    @Override
    public byte[] compress(byte[] in) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteArray decompress(byte[] input) throws NoPlantumlCompressionException {
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(input));){
            ByteArray byteArray;
            ZipEntry ent = zis.getNextEntry();
            String name = ent.getName();
            byte[] buffer = new byte[10000];
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                    if (baos.size() <= 200000) continue;
                    throw new NoPlantumlCompressionException("Zip error");
                }
                byteArray = ByteArray.from(baos.toByteArray());
            }
            return byteArray;
        }
        catch (IOException e) {
            throw new NoPlantumlCompressionException(e);
        }
    }
}

