/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.util.zip.Deflater;
import znaishaded.net.sourceforge.plantuml.code.ByteArray;
import znaishaded.net.sourceforge.plantuml.code.Compression;
import znaishaded.net.sourceforge.plantuml.code.CompressionZopfliZlib;
import znaishaded.net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import znaishaded.net.sourceforge.plantuml.code.deflate.ByteBitInputStream;
import znaishaded.net.sourceforge.plantuml.code.deflate.Decompressor;

public class CompressionZlib
implements Compression {
    private static boolean USE_ZOPFLI = false;
    private static final int COMPRESSION_LEVEL = 9;

    @Override
    public byte[] compress(byte[] in) {
        if (USE_ZOPFLI) {
            return new CompressionZopfliZlib().compress(in);
        }
        if (in.length == 0) {
            return null;
        }
        int len = in.length * 2;
        if (len < 1000) {
            len = 1000;
        }
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(in);
        compresser.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compresser.deflate(output);
        if (!compresser.finished()) {
            return null;
        }
        return this.copyArray(output, compressedDataLength);
    }

    @Override
    public ByteArray decompress(byte[] input) throws NoPlantumlCompressionException {
        byte[] padded = new byte[input.length + 256];
        System.arraycopy(input, 0, padded, 0, input.length);
        ByteBitInputStream inputStream = new ByteBitInputStream(new ByteArrayInputStream(padded));
        try {
            return ByteArray.from(Decompressor.decompress(inputStream));
        }
        catch (Exception e) {
            throw new NoPlantumlCompressionException(e);
        }
    }

    private byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }
}

