/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.svek.GroupMakerActivity;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierActivity {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierActivity(ICucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            ArrayList<Entity> groups = new ArrayList<Entity>(diagram.getEntityFactory().groups());
            for (Entity g2 : groups) {
                if (!g2.isAutarkic()) continue;
                IEntityImage img = this.computeImage(g2);
                g2.overrideImage(img, LeafType.ACTIVITY);
                changed = true;
            }
        } while (changed);
    }

    private IEntityImage computeImage(Entity g2) throws IOException, InterruptedException {
        GroupMakerActivity maker = new GroupMakerActivity(this.diagram, g2, this.stringBounder);
        return maker.getImage();
    }
}

