/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphml;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import znaishaded.net.sourceforge.plantuml.xml.XmlFactories;

public class GraphmlDescriptionDiagram
implements XmlDiagramTransformer {
    private final DescriptionDiagram diagram;
    private final Document document;

    public GraphmlDescriptionDiagram(DescriptionDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element graphml = this.document.createElement("graphml");
        graphml.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        graphml.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        graphml.setAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        this.document.appendChild(graphml);
        Element graph = this.document.createElement("graph");
        graph.setAttribute("edgedefault", "undirected");
        graphml.appendChild(graph);
        for (Entity ent : diagram.getEntityFactory().leafs()) {
            if (!ent.getParentContainer().isRoot()) continue;
            this.addElement(ent, graph);
        }
    }

    private void addElement(Entity tobeAdded, Element container) {
        Element element = this.createEntityNode(tobeAdded);
        container.appendChild(element);
    }

    private Element createEntityNode(Entity entity) {
        Element cla = this.document.createElement("node");
        cla.setAttribute("id", entity.getName());
        return cla;
    }

    @Override
    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }
}

