/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Parser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomHorizontalTexts;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomImg;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomOpenIcon;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomSprite;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomVerticalTexts;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Splitter;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ImgValign;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class AtomTextUtils {
    protected static AtomText.DelayedDouble ZERO = new AtomText.DelayedDouble(){

        @Override
        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private static final Pattern p = Pattern.compile("\\<&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>|\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>|\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>|" + Splitter.emojiPattern);

    public static Atom createLegacy(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO, true);
    }

    public static Atom create(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO, false);
    }

    public static Atom createUrl(Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        fontConfiguration = fontConfiguration.hyperlink();
        Display display = Display.getWithNewlines(url.getLabel());
        if (display.size() > 1) {
            ArrayList<Atom> all = new ArrayList<Atom>();
            for (CharSequence charSequence : display.asList()) {
                all.add(AtomTextUtils.createAtomText(charSequence.toString(), url, fontConfiguration, skinSimple));
            }
            return new AtomVerticalTexts(all);
        }
        return AtomTextUtils.createAtomText(url.getLabel(), url, fontConfiguration, skinSimple);
    }

    private static Atom createAtomText(String text, Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        StringBuffer sb;
        Matcher m3 = p.matcher(text);
        ArrayList<Atom> result = new ArrayList<Atom>();
        while (m3.find()) {
            double scale;
            sb = new StringBuffer();
            m3.appendReplacement(sb, "");
            if (sb.length() > 0) {
                result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO, true));
            }
            String valOpenicon = m3.group(1);
            String valSprite = m3.group(3);
            String valImg = m3.group(5);
            String valEmoji = m3.group(7);
            if (valEmoji != null) {
                throw new UnsupportedOperationException();
            }
            if (valOpenicon != null) {
                OpenIcon openIcon = OpenIcon.retrieve(valOpenicon);
                if (openIcon == null) continue;
                scale = Parser.getScale(m3.group(2), 1.0);
                result.add(new AtomOpenIcon(null, scale, openIcon, fontConfiguration, url));
                continue;
            }
            if (valSprite != null) {
                Sprite sprite = skinSimple.getSprite(valSprite);
                if (sprite == null) continue;
                scale = Parser.getScale(m3.group(4), 1.0);
                result.add(new AtomSprite(null, scale, fontConfiguration, sprite, url));
                continue;
            }
            if (valImg == null) continue;
            double scale2 = Parser.getScale(m3.group(6), 1.0);
            result.add(AtomImg.create(valImg, ImgValign.TOP, 0, scale2, url));
        }
        sb = new StringBuffer();
        m3.appendTail(sb);
        if (sb.length() > 0) {
            result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO, true));
        }
        if (result.size() == 1) {
            return (Atom)result.get(0);
        }
        return new AtomHorizontalTexts(result);
    }

    public static Atom createListNumber(final FontConfiguration fontConfiguration, final int order, int localNumber) {
        AtomText.DelayedDouble left = new AtomText.DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                XDimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), "9. ");
                return dim.getWidth() * (double)order;
            }
        };
        AtomText.DelayedDouble right = new AtomText.DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                XDimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), ".");
                return dim.getWidth();
            }
        };
        return new AtomText("" + (localNumber + 1) + ".", fontConfiguration, null, left, right, true);
    }
}

