/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d.DriverRectangleG2d;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d.DriverShadowedG2d;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;

public class DriverLineG2d
extends DriverShadowedG2d
implements UDriver<ULine, Graphics2D> {
    private final double dpiFactor;

    public DriverLineG2d(double dpiFactor) {
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(ULine shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        Line2D.Double line = new Line2D.Double(x, y, x + shape.getDX(), y + shape.getDY());
        DriverLineG2d.manageStroke(param, g2d);
        if (shape.getDeltaShadow() != 0.0) {
            this.drawShadow(g2d, line, shape.getDeltaShadow(), this.dpiFactor);
        }
        HColor color = param.getColor();
        DriverRectangleG2d.drawBorder(param, color, mapper, shape, line, g2d, x, y);
    }

    static void manageStroke(UParam param, Graphics2D g2d) {
        DriverLineG2d.manageStroke(param.getStroke(), g2d);
    }

    static void manageStroke(UStroke stroke, Graphics2D g2d) {
        float thickness = (float)stroke.getThickness();
        if (stroke.getDashVisible() == 0.0) {
            g2d.setStroke(new BasicStroke(thickness));
        } else {
            float dash1 = (float)stroke.getDashVisible();
            float dash2 = (float)stroke.getDashSpace();
            float[] style = new float[]{dash1, dash2};
            g2d.setStroke(new BasicStroke(thickness, 0, 0, 10.0f, style, 0.0f));
        }
    }
}

