/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.svg;

import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UClip;
import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d.DriverShadowedG2d;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverRectangleSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<UPath, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        if (shape.isOpenIconic()) {
            HColor color = param.getColor();
            svg.setFillColor(color.toSvg(mapper));
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            DriverRectangleSvg.applyFillColor(svg, mapper, param);
            DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

