/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import java.awt.image.BufferedImage;
import java.util.Objects;
import znaishaded.net.atmp.PixelImage;
import znaishaded.net.sourceforge.plantuml.klimt.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ImgValign;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;

public class TileImage
extends AbstractTextBlock
implements TextBlock {
    private final BufferedImage image;
    private final int vspace;

    public TileImage(BufferedImage image, ImgValign valign, int vspace) {
        this.image = Objects.requireNonNull(image);
        this.vspace = vspace;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.image.getWidth(), this.image.getHeight() + 2 * this.vspace);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(UTranslate.dy(this.vspace)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
    }
}

