/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class ReferenceTile
extends AbstractTile
implements Tile {
    private final Reference reference;
    private final TileArguments tileArguments;
    private Real first;
    private Real last;
    private final YGauge yGauge;
    private Component noteLeft;
    private Component noteRight;

    @Override
    public Event getEvent() {
        return this.reference;
    }

    public ReferenceTile(Reference reference, TileArguments tileArguments, YGauge currentY) {
        super(tileArguments.getStringBounder(), currentY);
        this.reference = reference;
        this.tileArguments = tileArguments;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
        for (Note noteOnMessage : reference.getNoteOnMessages()) {
            ISkinParam skinParam2 = noteOnMessage.getSkinParamBackcolored(tileArguments.getSkinParam());
            Component note = tileArguments.getSkin().createComponentNote(noteOnMessage.getUsedStyles(), noteOnMessage.getNoteStyle().getNoteComponentType(), skinParam2, noteOnMessage.getDisplay(), noteOnMessage.getColors());
            if (noteOnMessage.getPosition() == NotePosition.RIGHT) {
                this.noteRight = note;
                continue;
            }
            this.noteLeft = note;
        }
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    private void init(StringBounder stringBounder) {
        if (this.first != null) {
            return;
        }
        for (Participant p : this.reference.getParticipant()) {
            LivingSpace livingSpace = this.tileArguments.getLivingSpace(p);
            Real pos = livingSpace.getPosC(stringBounder);
            if (this.first == null || pos.getCurrentValue() < this.first.getCurrentValue()) {
                this.first = livingSpace.getPosB(stringBounder);
            }
            if (this.last != null && !(pos.getCurrentValue() > this.last.getCurrentValue())) continue;
            this.last = livingSpace.getPosD(stringBounder);
        }
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        if (this.reference.getParticipant().size() == 1) {
            this.last = this.last.addAtLeast(0.0);
        }
        this.last.ensureBiggerThan(this.first.addFixed(dim.getWidth()));
    }

    private Component getComponent(StringBounder stringBounder) {
        Display strings = Display.empty();
        strings = strings.add("ref");
        strings = strings.addAll(this.reference.getStrings());
        Component comp = this.tileArguments.getSkin().createComponent(this.reference.getUsedStyles(), ComponentType.REFERENCE, null, this.tileArguments.getSkinParam(), strings);
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        double hn;
        double wn;
        StringBounder stringBounder = ug.getStringBounder();
        this.init(stringBounder);
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = Area.create(this.last.getCurrentValue() - this.first.getCurrentValue(), dim.getHeight());
        comp.drawU(ug.apply(UTranslate.dx(this.first.getCurrentValue())), area, (Context2D)((Object)ug));
        if (this.noteLeft != null) {
            wn = this.noteLeft.getPreferredWidth(stringBounder);
            hn = this.noteLeft.getPreferredHeight(stringBounder);
            this.noteLeft.drawU(ug.apply(UTranslate.dx(this.first.getCurrentValue() - wn)), new Area(new XDimension2D(wn, hn)), (Context2D)((Object)ug));
        }
        if (this.noteRight != null) {
            wn = this.noteRight.getPreferredWidth(stringBounder);
            hn = this.noteRight.getPreferredHeight(stringBounder);
            this.noteRight.drawU(ug.apply(UTranslate.dx(this.last.getCurrentValue())), new Area(new XDimension2D(wn, hn)), (Context2D)((Object)ug));
        }
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        this.init(this.getStringBounder());
        if (this.noteLeft != null) {
            double wn = this.noteLeft.getPreferredWidth(this.getStringBounder());
            return this.first.addFixed(-wn);
        }
        return this.first;
    }

    @Override
    public Real getMaxX() {
        this.init(this.getStringBounder());
        if (this.noteRight != null) {
            double wn = this.noteRight.getPreferredWidth(this.getStringBounder());
            return this.last.addFixed(wn);
        }
        return this.last;
    }
}

