/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityStateLine1
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final XPoint2D dest;
    private final double radius = 7.0;
    private final double angle;

    @Override
    public XPoint2D somePoint() {
        return this.dest;
    }

    public ExtremityStateLine1(double angle, XPoint2D center) {
        this.angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new XPoint2D(center.getX(), center.getY());
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(center.getX(), center.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(ug.getParam().getColor().bg()).apply(new UTranslate(-7.0 * Math.cos(this.angle), -7.0 * Math.sin(this.angle))).draw(this.polygon);
        ug = ug.apply(HColors.WHITE.bg());
        ug.apply(UStroke.withThickness(1.5)).apply(new UTranslate(this.dest.getX() - 7.0, this.dest.getY() - 7.0)).draw(UEllipse.build(14.0, 14.0));
        ExtremityStateLine1.drawLine(ug, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 3.9269908169872414));
        ExtremityStateLine1.drawLine(ug, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), -0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 2.356194490192345));
    }

    private XPoint2D getPointOnCircle(double centerX, double centerY, double angle) {
        double x = centerX + 7.0 * Math.cos(angle);
        double y = centerY + 7.0 * Math.sin(angle);
        return new XPoint2D(x, y);
    }

    private static void drawLine(UGraphic ug, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(p1.getX(), p1.getY())).draw(new ULine(dx, dy));
    }
}

