/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;

public class EntityImagePort
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImagePort(Entity leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, parent, bibliotekon, FontParam.BOUNDARY);
        this.sname = sname;
    }

    @Override
    protected StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.port);
    }

    private boolean upPosition() {
        XPoint2D clusterCenter = this.parent.getRectangleArea().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double sp = 12.0;
        return new XDimension2D(sp, sp);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        TextBlock desc = this.getDesc();
        XDimension2D dimDesc = desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    private void drawSymbol(UGraphic ug) {
        URectangle rect = URectangle.build(12.0, 12.0);
        ug.draw(rect);
    }

    @Override
    public final void drawU(UGraphic ug) {
        TextBlock desc = this.getDesc();
        double y = 0.0;
        XDimension2D dimDesc = desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        desc.drawU(ug.apply(new UTranslate(x, y)));
        Style style = this.getStyle();
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor borderColor = this.getEntity().getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(borderColor);
        ug = ug.apply(this.getUStroke()).apply(backcolor.bg());
        this.drawSymbol(ug);
    }

    private UStroke getUStroke() {
        return UStroke.withThickness(1.5);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE_PORT;
    }
}

