/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.statediagram.StateDiagram;
import znaishaded.net.sourceforge.plantuml.utils.Log;
import znaishaded.net.sourceforge.plantuml.xmi.XmiClassDiagramArgo;
import znaishaded.net.sourceforge.plantuml.xmi.XmiClassDiagramStandard;
import znaishaded.net.sourceforge.plantuml.xmi.XmiClassDiagramStar;
import znaishaded.net.sourceforge.plantuml.xmi.XmiDescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.xmi.XmiStateDiagram;
import znaishaded.net.sourceforge.plantuml.xmi.XmlDiagramTransformer;

public final class CucaDiagramXmiMaker {
    private final ICucaDiagram diagram;
    private final FileFormat fileFormat;

    public CucaDiagramXmiMaker(ICucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.diagram = diagram;
        this.fileFormat = fileFormat;
    }

    public static String getModel(UmlDiagram classDiagram) {
        return "model1";
    }

    public void createFiles(OutputStream fos) throws IOException {
        try {
            XmlDiagramTransformer xmi;
            if (this.diagram instanceof StateDiagram) {
                xmi = new XmiStateDiagram((StateDiagram)this.diagram);
            } else if (this.diagram instanceof DescriptionDiagram) {
                xmi = new XmiDescriptionDiagram((DescriptionDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STANDARD) {
                xmi = new XmiClassDiagramStandard((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_ARGO) {
                xmi = new XmiClassDiagramArgo((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STAR) {
                xmi = new XmiClassDiagramStar((ClassDiagram)this.diagram);
            } else {
                throw new UnsupportedOperationException();
            }
            xmi.transformerXml(fos);
        }
        catch (ParserConfigurationException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
        catch (TransformerException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
    }
}

