/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.zopfli;

import znaishaded.net.sourceforge.plantuml.zopfli.Cookie;

class LongestMatchCache {
    private static final int CACHE_LENGTH = 8;
    public final char[] length;
    public final char[] dist;
    private final char[] subLenPos;
    private final byte[] subLenLen;

    LongestMatchCache(int maxBlockSize) {
        this.length = new char[maxBlockSize];
        this.dist = new char[maxBlockSize];
        this.subLenPos = new char[8 * maxBlockSize];
        this.subLenLen = new byte[8 * maxBlockSize];
    }

    void init(int blockSize) {
        int l;
        int j;
        Cookie.fill0(this.dist, blockSize);
        int n = blockSize << 3;
        char[] subLenPos = this.subLenPos;
        byte[] subLenLen = this.subLenLen;
        char[] length = this.length;
        char[] charZeroes = Cookie.charZeroes;
        byte[] byteZeroes = Cookie.byteZeroes;
        char[] charOnes = Cookie.charOnes;
        int i = 0;
        while (i < n) {
            j = i + 65536;
            if (j > n) {
                j = n;
            }
            l = j - i;
            System.arraycopy(byteZeroes, 0, subLenLen, i, l);
            System.arraycopy(charZeroes, 0, subLenPos, i, l);
            i = j;
        }
        i = 0;
        while (i < blockSize) {
            j = i + 65536;
            if (j > blockSize) {
                j = blockSize;
            }
            l = j - i;
            System.arraycopy(charOnes, 0, length, i, l);
            System.arraycopy(charZeroes, 0, subLenPos, i, l);
            i = j;
        }
    }

    void subLenToCache(char[] input, int pos, int len) {
        if (len < 3) {
            return;
        }
        int bestLength = 0;
        int j = pos * 8;
        int last = j + 8 - 1;
        for (int i = 3; i <= len; ++i) {
            if (i != len && input[i] == input[i + 1]) continue;
            this.subLenPos[j] = input[i];
            this.subLenLen[j] = (byte)(i - 3);
            bestLength = i;
            if (++j > last) break;
        }
        if (j <= last) {
            this.subLenLen[last] = (byte)(bestLength - 3);
        }
    }

    void cacheToSubLen(int pos, int len, char[] output) {
        int j;
        if (len < 3) {
            return;
        }
        int maxLength = this.maxCachedSubLen(pos);
        int prevLength = 0;
        int last = j + 8;
        for (j = 8 * pos; j < last; ++j) {
            int cLen = (this.subLenLen[j] & 0xFF) + 3;
            char dist = this.subLenPos[j];
            for (int i = prevLength; i <= cLen; ++i) {
                output[i] = dist;
            }
            if (cLen == maxLength) break;
            prevLength = cLen + 1;
        }
    }

    int maxCachedSubLen(int pos) {
        if (this.subLenPos[pos *= 8] == '\u0000') {
            return 0;
        }
        return (this.subLenLen[pos + 8 - 1] & 0xFF) + 3;
    }
}

