/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.client.protocol;

import java.io.IOException;
import znaishaded.org.apache.http.HttpEntity;
import znaishaded.org.apache.http.HttpEntityEnclosingRequest;
import znaishaded.org.apache.http.HttpException;
import znaishaded.org.apache.http.HttpRequest;
import znaishaded.org.apache.http.HttpRequestInterceptor;
import znaishaded.org.apache.http.HttpVersion;
import znaishaded.org.apache.http.ProtocolVersion;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.client.config.RequestConfig;
import znaishaded.org.apache.http.client.protocol.HttpClientContext;
import znaishaded.org.apache.http.protocol.HttpContext;
import znaishaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

