/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.utils.NameUtils;

public class PageSectionIdTitle {
    private final String title;
    private final String id;
    private final Map<String, ?> headingProps;

    public PageSectionIdTitle(String title, Map<String, ?> headingProps) {
        this.title = title;
        this.id = PageSectionIdTitle.buildOrGetId(title, headingProps);
        this.headingProps = headingProps;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ?> getHeadingProps() {
        return this.headingProps;
    }

    public Map<String, ?> toMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("title", this.getTitle());
        result.put("id", this.getId());
        result.putAll(this.getHeadingProps());
        return result;
    }

    private static String buildOrGetId(String title, Map<String, ?> headingProps) {
        Object anchorId = headingProps.get("customAnchorId");
        return anchorId == null ? NameUtils.idFromTitle(title) : anchorId.toString();
    }
}

