/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.nio.file.Path;
import org.testingisdocumenting.znai.utils.FilePathUtils;
import org.testingisdocumenting.znai.utils.UrlUtils;

public class DocUrl {
    private static final String LINK_TO_SECTION_INSTRUCTION = "To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  ../dir-name/file-name.md#page-section-id or\n  ./file-name-within-chapter.md#page-section-id\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n";
    private String dirName = "";
    private String fileNameWithoutExtension = "";
    private String anchorId = "";
    private String url;
    private boolean isExternalUrl;
    private boolean isAnchorOnly;
    private boolean isIndexUrl;

    public static DocUrl indexUrl() {
        return new DocUrl(true);
    }

    private DocUrl(boolean isIndexUrl) {
        this.isIndexUrl = isIndexUrl;
    }

    public DocUrl(String dirName, String fileNameWithoutExtension, String anchorId) {
        this.dirName = dirName;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
        this.anchorId = anchorId;
    }

    public DocUrl(Path markupPath, String url) {
        boolean handled;
        this.url = url;
        boolean bl = handled = this.handleExternal() || this.handleIndex() || this.handleAnchorOnly() || this.handleLocal(markupPath);
        if (!handled) {
            throw new IllegalStateException("couldn't parse url: " + url);
        }
    }

    private boolean handleExternal() {
        this.isExternalUrl = UrlUtils.isExternal(this.url);
        return this.isExternalUrl;
    }

    private boolean handleIndex() {
        if (this.url.startsWith("/#")) {
            this.isIndexUrl = true;
            this.anchorId = this.url.substring(2);
            return true;
        }
        this.isIndexUrl = this.url.equals("/");
        return this.isIndexUrl;
    }

    private boolean handleAnchorOnly() {
        this.isAnchorOnly = this.url.startsWith("#");
        if (this.isAnchorOnly) {
            this.dirName = "";
            this.fileNameWithoutExtension = "";
            this.anchorId = this.url.substring(1);
        }
        return this.isAnchorOnly;
    }

    private boolean handleLocal(Path markupPath) {
        String[] parts = this.url.split("/");
        if (parts.length == 1) {
            return this.handleNoDirSpecified(markupPath, parts[0]);
        }
        if (parts.length != 2 && parts.length != 3) {
            throw new IllegalArgumentException("Unexpected url pattern: <" + this.url + "> To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  ../dir-name/file-name.md#page-section-id or\n  ./file-name-within-chapter.md#page-section-id\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n");
        }
        if (parts.length == 3 && !parts[0].equals("..")) {
            throw new IllegalArgumentException("Unexpected url pattern: <" + this.url + "> To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  ../dir-name/file-name.md#page-section-id or\n  ./file-name-within-chapter.md#page-section-id\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n");
        }
        int dirIdx = parts.length == 3 ? 1 : 0;
        int nameIdx = parts.length == 3 ? 2 : 1;
        this.dirName = DocUrl.replaceDirNameIfRequired(markupPath, parts[dirIdx]);
        int idxOfAnchorSep = parts[nameIdx].indexOf(35);
        this.fileNameWithoutExtension = FilePathUtils.fileNameWithoutExtension(idxOfAnchorSep == -1 ? parts[nameIdx] : parts[nameIdx].substring(0, idxOfAnchorSep));
        this.anchorId = idxOfAnchorSep == -1 ? "" : parts[nameIdx].substring(idxOfAnchorSep + 1);
        return true;
    }

    private boolean handleNoDirSpecified(Path markupPath, String part) {
        int idxOfAnchorSep = part.indexOf(35);
        this.dirName = DocUrl.replaceDirNameIfRequired(markupPath, "");
        this.fileNameWithoutExtension = FilePathUtils.fileNameWithoutExtension(idxOfAnchorSep == -1 ? part : part.substring(0, idxOfAnchorSep));
        this.anchorId = idxOfAnchorSep == -1 ? "" : part.substring(idxOfAnchorSep + 1);
        return true;
    }

    private static String replaceDirNameIfRequired(Path markupPath, String currentDirName) {
        if (currentDirName.equals(".") || currentDirName.isEmpty()) {
            Path parentPath = markupPath.getParent();
            return parentPath != null ? parentPath.getFileName().toString() : "";
        }
        return currentDirName;
    }

    public boolean isIndexUrl() {
        return this.isIndexUrl;
    }

    public boolean isExternalUrl() {
        return this.isExternalUrl;
    }

    public boolean isAnchorOnly() {
        return this.isAnchorOnly;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public String getAnchorId() {
        return this.anchorId;
    }

    public String getAnchorIdWithHash() {
        return this.anchorId.isEmpty() ? "" : "#" + this.anchorId;
    }

    public String getUrl() {
        return this.url;
    }
}

