/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.processors.validation;

import javax.annotation.ParametersAreNonnullByDefault;
import znaishaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.SyntaxProcessor;
import znaishaded.com.github.fge.jsonschema.core.load.RefResolver;
import znaishaded.com.github.fge.jsonschema.core.processing.CachingProcessor;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.processing.ProcessorChain;
import znaishaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.jsonschema.core.util.ValueHolder;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import znaishaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import znaishaded.com.github.fge.jsonschema.processors.digest.SchemaDigester;
import znaishaded.com.github.fge.jsonschema.processors.format.FormatProcessor;
import znaishaded.com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import znaishaded.com.google.common.base.Equivalence;

public final class ValidationChain
implements Processor<SchemaContext, ValidatorList> {
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> resolver;
    private final Processor<SchemaContext, ValidatorList> builder;

    public ValidationChain(RefResolver refResolver, Library library, ValidationConfiguration cfg) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(cfg.getSyntaxMessages(), library.getSyntaxCheckers());
        ProcessorChain<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> chain1 = ProcessorChain.startWith(refResolver).chainWith(syntaxProcessor);
        this.resolver = new CachingProcessor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>>(chain1.getProcessor(), SchemaHolderEquivalence.INSTANCE, cfg.getCacheSize());
        SchemaDigester digester = new SchemaDigester(library);
        ValidatorBuilder keywordBuilder = new ValidatorBuilder(library);
        ProcessorChain<SchemaContext, ValidatorList> chain2 = ProcessorChain.startWith(digester).chainWith(keywordBuilder);
        if (cfg.getUseFormat()) {
            FormatProcessor format = new FormatProcessor(library, cfg);
            chain2 = chain2.chainWith(format);
        }
        this.builder = new CachingProcessor<SchemaContext, ValidatorList>(chain2.getProcessor(), SchemaContextEquivalence.getInstance(), cfg.getCacheSize());
    }

    @Override
    public ValidatorList process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        ValueHolder<SchemaTree> in = ValueHolder.hold("schema", input.getSchema());
        ListProcessingReport r = new ListProcessingReport(report);
        ValueHolder<SchemaTree> out = this.resolver.process(r, in);
        report.mergeWith(r);
        if (!r.isSuccess()) {
            return null;
        }
        SchemaContext output = new SchemaContext(out.getValue(), input.getInstanceType());
        return this.builder.process(report, output);
    }

    public String toString() {
        return this.resolver + " -> " + this.builder;
    }

    @ParametersAreNonnullByDefault
    private static final class SchemaHolderEquivalence
    extends Equivalence<ValueHolder<SchemaTree>> {
        private static final Equivalence<ValueHolder<SchemaTree>> INSTANCE = new SchemaHolderEquivalence();

        private SchemaHolderEquivalence() {
        }

        @Override
        protected boolean doEquivalent(ValueHolder<SchemaTree> a, ValueHolder<SchemaTree> b) {
            return a.getValue().equals(b.getValue());
        }

        @Override
        protected int doHash(ValueHolder<SchemaTree> t) {
            return t.getValue().hashCode();
        }
    }
}

