/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.processors;

import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.RefResponse;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.models.Swagger;
import znaishaded.io.swagger.models.refs.RefFormat;
import znaishaded.io.swagger.parser.ResolverCache;
import znaishaded.io.swagger.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.parser.processors.ModelProcessor;
import znaishaded.io.swagger.parser.util.RefUtils;

public class ResponseProcessor {
    private final ModelProcessor modelProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ResponseProcessor(ResolverCache cache, Swagger swagger) {
        this.modelProcessor = new ModelProcessor(cache, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processResponse(Response response) {
        Model schema = response.getResponseSchema();
        if (response instanceof RefResponse) {
            RefResponse refResponse = (RefResponse)response;
            this.processReferenceResponse(refResponse);
        }
        if (schema != null) {
            this.modelProcessor.processModel(schema);
        }
    }

    public void processReferenceResponse(RefResponse refResponse) {
        RefFormat refFormat = refResponse.getRefFormat();
        String $ref = refResponse.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat)) {
            this.externalRefProcessor.processRefToExternalResponse($ref, refFormat);
        }
    }
}

