/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.GeneratedImage;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class GeneratedImageImpl
implements GeneratedImage {
    private final SFile pngFile;
    private final String description;
    private final BlockUml blockUml;
    private final int status;

    @Override
    public final int getStatus() {
        return this.status;
    }

    public GeneratedImageImpl(SFile pngFile, String description, BlockUml blockUml, int status) {
        this.blockUml = blockUml;
        this.pngFile = pngFile;
        this.description = description;
        this.status = status;
    }

    @Override
    public File getPngFile() {
        return this.pngFile.conv();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int lineErrorRaw() {
        Diagram system = this.blockUml.getDiagram();
        if (system instanceof PSystemError) {
            return ((PSystemError)system).getLineLocation().getPosition();
        }
        return -1;
    }

    public String toString() {
        return this.pngFile.getPrintablePath() + " " + this.description;
    }

    @Override
    public int compareTo(GeneratedImage this2) {
        try {
            int cmp = this.getPngFile().getCanonicalPath().compareTo(this2.getPngFile().getCanonicalPath());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (IOException e) {
            Logme.error(e);
        }
        return this.description.compareTo(this2.getDescription());
    }

    public int hashCode() {
        return this.pngFile.hashCode() + this.description.hashCode();
    }

    public boolean equals(Object obj) {
        GeneratedImageImpl this2 = (GeneratedImageImpl)obj;
        return this2.pngFile.equals(this.pngFile) && this2.description.equals(this.description);
    }

    public BlockUml getBlockUml() {
        return this.blockUml;
    }
}

