/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileCircleSpot;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class InstructionSpot
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final LinkRendering inlinkRendering;
    private final String spot;
    private final HColor color;

    @Override
    public boolean containsBreak() {
        return false;
    }

    public InstructionSpot(String spot, HColor color, LinkRendering inlinkRendering, Swimlane swimlane) {
        super(swimlane);
        this.spot = spot;
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.color = color;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.spot(this.getSwimlaneIn(), this.spot, this.color);
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn(), VerticalAlignment.CENTER);
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        UFont font = skinParam.getFont(null, false, FontParam.ACTIVITY);
        return new GtileCircleSpot(stringBounder, skinParam, this.color, this.getSwimlaneIn(), this.spot, font);
    }

    @Override
    public CommandExecutionResult add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

