/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.jsondiagram;

import h.ST_Agedgeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.jsondiagram.Arrow;
import znaishaded.net.sourceforge.plantuml.jsondiagram.Mirror;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;

public class JsonCurve {
    private final List<XPoint2D> points = new ArrayList<XPoint2D>();
    private double maxX;
    private double maxY;
    private final Mirror xMirror;
    private final double veryFirstLine;
    private final XPoint2D sp;
    private final XPoint2D ep;

    public JsonCurve(ST_Agedgeinfo_t data, Mirror xMirror, double veryFirstLine) {
        this.veryFirstLine = veryFirstLine;
        this.xMirror = xMirror;
        ST_splines splines = data.spl;
        if (splines.size != 1) {
            throw new IllegalStateException();
        }
        ST_bezier beziers = splines.list.get__(0);
        for (int i = 0; i < beziers.size; ++i) {
            XPoint2D pt = this.getPoint(splines, i);
            this.maxX = Math.max(this.maxX, pt.getX());
            this.maxY = Math.max(this.maxY, pt.getY());
            this.points.add(pt);
        }
        this.sp = beziers.sp.x == 0.0 && beziers.sp.y == 0.0 ? null : new XPoint2D(beziers.sp.x, beziers.sp.y);
        this.ep = beziers.ep.x == 0.0 && beziers.ep.y == 0.0 ? null : new XPoint2D(beziers.ep.x, beziers.ep.y);
    }

    private XPoint2D getPoint(ST_splines splines, int i) {
        ST_bezier beziers = splines.list.get__(0);
        ST_pointf pt = beziers.list.get__(i);
        return new XPoint2D(pt.x, pt.y);
    }

    public void drawCurve(HColor color, UGraphic ug) {
        UPath path = UPath.none();
        path.moveTo(this.getVeryFirst());
        path.lineTo(this.xMirror.invAndXYSwitch(this.points.get(0)));
        for (int i = 1; i < this.points.size(); i += 3) {
            XPoint2D pt2 = this.xMirror.invAndXYSwitch(this.points.get(i));
            XPoint2D pt3 = this.xMirror.invAndXYSwitch(this.points.get(i + 1));
            XPoint2D pt4 = this.xMirror.invAndXYSwitch(this.points.get(i + 2));
            path.cubicTo(pt2, pt3, pt4);
        }
        ug.draw(path);
        if (this.ep != null) {
            XPoint2D last = this.xMirror.invAndXYSwitch(this.points.get(this.points.size() - 1));
            XPoint2D trueEp = this.xMirror.invAndXYSwitch(this.ep);
            new Arrow(last, trueEp).drawArrow(ug.apply(color.bg()));
        }
    }

    public void drawSpot(UGraphic ug) {
        double size = 3.0;
        ug = ug.apply(UTranslate.point(this.getVeryFirst()).compose(new UTranslate(-3.0, -3.0)));
        ug.apply(UStroke.simple()).draw(UEllipse.build(6.0, 6.0));
    }

    private XPoint2D getVeryFirst() {
        return JsonCurve.supp(this.xMirror.invAndXYSwitch(this.points.get(0)), this.xMirror.invAndXYSwitch(this.points.get(1)), this.veryFirstLine);
    }

    private static XPoint2D supp(XPoint2D center, XPoint2D direction, double len) {
        double full = center.distance(direction);
        double dx = (center.getX() - direction.getX()) / full;
        double dy = (center.getY() - direction.getY()) / full;
        return new XPoint2D(center.getX() + dx * len, center.getY() + dy * len);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

