/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorRuntimeException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Parser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBuilder;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.CreoleStripeSimpleParser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeCode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeLatex;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeRaw;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeTable;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeTree;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class CreoleParser
implements SheetBuilder {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;
    private final CreoleMode creoleMode;
    private final FontConfiguration stereotype;
    private final Map<Display, Sheet> cache = new HashMap<Display, Sheet>();

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode, FontConfiguration stereotype) {
        this.stereotype = stereotype;
        this.creoleMode = creoleMode;
        this.fontConfiguration = fontConfiguration;
        this.skinParam = Objects.requireNonNull(skinParam);
        this.horizontalAlignment = horizontalAlignment;
    }

    private Stripe createStripe(String line, CreoleContext context, Stripe lastStripe, FontConfiguration fontConfiguration) {
        if (lastStripe instanceof StripeRaw) {
            StripeRaw code = (StripeRaw)lastStripe;
            if (code.isTerminated()) {
                lastStripe = null;
            } else {
                boolean terminated = code.addAndCheckTermination(line);
                return null;
            }
        }
        if (lastStripe instanceof StripeTable && CreoleParser.isTableLine(line)) {
            StripeTable table = (StripeTable)lastStripe;
            table.analyzeAndAddLine(line);
            return null;
        }
        if (lastStripe instanceof StripeTree && Parser.isTreeStart(StringUtils.trinNoTrace(line))) {
            StripeTree tree = (StripeTree)lastStripe;
            tree.analyzeAndAdd(line);
            return null;
        }
        if (CreoleParser.isTableLine(line)) {
            return new StripeTable(fontConfiguration, this.skinParam, line);
        }
        if (Parser.isTreeStart(line)) {
            return new StripeTree(fontConfiguration, this.skinParam, line);
        }
        if (Parser.isCodeStart(line)) {
            return new StripeCode(fontConfiguration.changeFamily("monospaced"));
        }
        if (Parser.isLatexStart(line)) {
            return new StripeLatex(fontConfiguration);
        }
        return new CreoleStripeSimpleParser(line, context, fontConfiguration, this.skinParam, this.creoleMode).createStripe(context);
    }

    public static boolean isTableLine(String line) {
        return line.matches("^(\\<#\\w+(,#?\\w+)?\\>)?\\|(\\=)?.*\\|$");
    }

    public static boolean doesStartByColor(String line) {
        return line.matches("^\\=?\\s*(\\<#\\w+(,#?\\w+)?\\>).*");
    }

    @Override
    public Sheet createSheet(Display display) {
        Sheet result = this.cache.get(display);
        if (result == null) {
            result = this.createSheetSlow(display, false);
            this.cache.put(display, result);
        }
        return result;
    }

    private Sheet createSheetSlow(Display display, boolean checkColor) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (!Display.isNull(display)) {
            CreoleContext context = new CreoleContext();
            Iterator it = display.iterator();
            while (it.hasNext()) {
                Stripe stripe;
                CharSequence cs = (CharSequence)it.next();
                String type = EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(cs));
                if (type != null) {
                    final EmbeddedDiagram embeddedDiagram = EmbeddedDiagram.createAndSkip(type, it, this.skinParam);
                    stripe = checkColor ? null : new Stripe(){

                        @Override
                        public Atom getLHeader() {
                            return null;
                        }

                        @Override
                        public List<Atom> getAtoms() {
                            return Arrays.asList(embeddedDiagram);
                        }
                    };
                } else {
                    if (cs instanceof Stereotype) {
                        if (!display.showStereotype()) continue;
                        for (String st : ((Stereotype)cs).getLabels(this.skinParam.guillemet())) {
                            sheet.add(this.createStripe(st, context, sheet.getLastStripe(), this.stereotype));
                        }
                        continue;
                    }
                    stripe = this.createStripe(this.skinParam.guillemet().manageGuillemet(cs.toString()), context, sheet.getLastStripe(), this.fontConfiguration);
                }
                if (stripe == null) continue;
                sheet.add(stripe);
            }
        }
        return sheet;
    }

    public static void checkColor(Display result) throws NoSuchColorException {
        FontConfiguration fc = FontConfiguration.blackBlueTrue(UFont.byDefault(10));
        try {
            new CreoleParser(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty(), CreoleMode.FULL, fc).createSheetSlow(result, true);
        }
        catch (NoSuchColorRuntimeException e) {
            throw new NoSuchColorException();
        }
    }
}

