/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.sprite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.PlainDiagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.donors.PSystemDonors;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockHorizontal;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.ResourcesUtils;

public class PSystemListInternalSprites
extends PlainDiagram {
    public PSystemListInternalSprites(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<b>List Current Sprites");
        lines.add("<i>Credit to");
        lines.add("http://www.archimatetool.com");
        lines.add(" ");
        for (String folder : ResourcesUtils.getJarFile("sprites", true)) {
            lines.add("<u>" + folder + "</u> :");
            lines.add(" ");
            for (String png : ResourcesUtils.getJarFile("sprites/" + folder, false)) {
                if (!png.endsWith(".png")) continue;
                String spriteName = png.substring(0, png.length() - 4);
                lines.add("<$archimate/" + spriteName + "> " + spriteName);
            }
        }
        List<TextBlock> cols = PSystemDonors.getCols(lines, 4, 0);
        return new TextBlockHorizontal(cols, VerticalAlignment.TOP);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }
}

