/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.MutingLine;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class LivingSpace {
    private final Participant p;
    private final ISkinParam skinParam;
    private final ComponentType headType;
    private final ComponentType tailType;
    private final MutingLine mutingLine;
    private final Rose rose = new Rose();
    private final LiveBoxes liveboxes;
    private final Real posB;
    private Real posC;
    private Real posD;
    private boolean create = false;
    private double createY = 0.0;
    private final ParticipantEnglober englober;
    private double marginBefore;
    private double marginAfter;

    public int getLevelAt(Tile tile, EventsHistoryMode mode) {
        return this.liveboxes.getLevelAt(tile.getEvent(), mode);
    }

    public void addStepForLivebox(Event event, double y) {
        this.liveboxes.addStep(event, y);
    }

    public String toString() {
        return this.p.getCode() + " B=" + this.posB.getCurrentValue() + "/C=" + LivingSpace.currentValue(this.posC) + "/D=" + LivingSpace.currentValue(this.posD);
    }

    private static String currentValue(Real pos) {
        if (pos == null) {
            return null;
        }
        return "" + pos.getCurrentValue();
    }

    public LivingSpace(Participant p, ParticipantEnglober englober, Rose skin, ISkinParam skinParam, Real position, List<Event> events) {
        this.p = p;
        this.skinParam = skinParam;
        this.englober = englober;
        this.posB = position;
        if (p.getType() == ParticipantType.PARTICIPANT) {
            this.headType = ComponentType.PARTICIPANT_HEAD;
            this.tailType = ComponentType.PARTICIPANT_TAIL;
        } else if (p.getType() == ParticipantType.ACTOR) {
            this.headType = ComponentType.ACTOR_HEAD;
            this.tailType = ComponentType.ACTOR_TAIL;
        } else if (p.getType() == ParticipantType.BOUNDARY) {
            this.headType = ComponentType.BOUNDARY_HEAD;
            this.tailType = ComponentType.BOUNDARY_TAIL;
        } else if (p.getType() == ParticipantType.CONTROL) {
            this.headType = ComponentType.CONTROL_HEAD;
            this.tailType = ComponentType.CONTROL_TAIL;
        } else if (p.getType() == ParticipantType.ENTITY) {
            this.headType = ComponentType.ENTITY_HEAD;
            this.tailType = ComponentType.ENTITY_TAIL;
        } else if (p.getType() == ParticipantType.QUEUE) {
            this.headType = ComponentType.QUEUE_HEAD;
            this.tailType = ComponentType.QUEUE_TAIL;
        } else if (p.getType() == ParticipantType.DATABASE) {
            this.headType = ComponentType.DATABASE_HEAD;
            this.tailType = ComponentType.DATABASE_TAIL;
        } else if (p.getType() == ParticipantType.COLLECTIONS) {
            this.headType = ComponentType.COLLECTIONS_HEAD;
            this.tailType = ComponentType.COLLECTIONS_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
        this.mutingLine = new MutingLine(skin, skinParam, events, p);
        this.liveboxes = new LiveBoxes(p, events, skin, skinParam);
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> events) {
        String strategy = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(strategy)) {
            return false;
        }
        for (Event ev : events) {
            if (!(ev instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLineAndLiveboxes(UGraphic ug, double height, Context2D context) {
        this.mutingLine.drawLine(ug, context, this.createY, height);
        this.liveboxes.drawBoxes(ug, context, this.createY, height);
    }

    public void drawHead(UGraphic ug, Context2D context, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        if (this.create && verticalAlignment == VerticalAlignment.BOTTOM) {
            return;
        }
        Component comp = this.rose.createComponent(this.p.getUsedStyles(), this.headType, null, this.skinParam, this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        XDimension2D dim = comp.getPreferredDimension(ug.getStringBounder());
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            ug = ug.apply(UTranslate.dx(-dim.getWidth()));
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            ug = ug.apply(UTranslate.dy(-dim.getHeight() / 2.0));
        }
        Area area = new Area(dim);
        Url url = this.getParticipant().getUrl();
        if (url != null) {
            ug.startUrl(url);
        }
        comp.drawU(ug, area, context);
        if (url != null) {
            ug.closeUrl();
        }
    }

    public XDimension2D getHeadPreferredDimension(StringBounder stringBounder) {
        Component comp = this.rose.createComponent(this.p.getUsedStyles(), this.headType, null, this.skinParam, this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        return this.getHeadPreferredDimension(stringBounder).getWidth();
    }

    public Real getPosC(StringBounder stringBounder) {
        if (this.posC == null) {
            this.posC = this.posB.addFixed(this.getPreferredWidth(stringBounder) / 2.0);
        }
        return this.posC;
    }

    public Real getPosC2(StringBounder stringBounder) {
        double delta = this.liveboxes.getMaxPosition(stringBounder);
        return this.getPosC(stringBounder).addFixed(delta);
    }

    public Real getPosD(StringBounder stringBounder) {
        if (this.posD == null) {
            this.posD = this.posB.addFixed(this.getPreferredWidth(stringBounder));
        }
        return this.posD;
    }

    public Real getPosB(StringBounder stringBounder) {
        return this.posB;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public void goCreate(double y) {
        this.createY = y;
        this.create = true;
    }

    public void goCreate() {
        this.create = true;
    }

    public void delayOn(double y, double height) {
        this.mutingLine.delayOn(y, height);
        this.liveboxes.delayOn(y, height);
    }

    public ParticipantEnglober getEnglober() {
        return this.englober;
    }

    public void ensureMarginBefore(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException();
        }
        this.marginBefore = Math.max(this.marginBefore, margin);
    }

    public void ensureMarginAfter(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException();
        }
        this.marginAfter = Math.max(this.marginAfter, margin);
    }

    public Real getPosA(StringBounder stringBounder) {
        return this.getPosB(stringBounder).addFixed(-this.marginBefore);
    }

    public Real getPosE(StringBounder stringBounder) {
        return this.getPosD(stringBounder).addFixed(this.marginAfter);
    }
}

