/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.swing;

import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import znaishaded.net.sourceforge.plantuml.GeneratedImage;

class SimpleLine
implements Comparable<SimpleLine> {
    private final File file;
    private final GeneratedImage generatedImage;
    private final Future<List<GeneratedImage>> future;

    public static SimpleLine fromFuture(File file, Future<List<GeneratedImage>> future) {
        return new SimpleLine(file, null, future);
    }

    public static SimpleLine fromGeneratedImage(File file, GeneratedImage generatedImage) {
        return new SimpleLine(file, generatedImage, null);
    }

    private SimpleLine(File file, GeneratedImage generatedImage, Future<List<GeneratedImage>> future) {
        this.generatedImage = generatedImage;
        this.file = file;
        this.future = future;
    }

    public File getFile() {
        return this.file;
    }

    public boolean pendingAndFinished() {
        return this.generatedImage == null && this.future.isDone();
    }

    public String toString() {
        if (this.generatedImage == null) {
            return this.file.getName() + " (...pending...)";
        }
        StringBuilder sb = new StringBuilder(this.generatedImage.getPngFile().getName());
        sb.append(" ");
        sb.append(this.generatedImage.getDescription());
        return sb.toString();
    }

    public Future<List<GeneratedImage>> getFuture() {
        return this.future;
    }

    @Override
    public int compareTo(SimpleLine other) {
        return this.toString().compareTo(other.toString());
    }

    public GeneratedImage getGeneratedImage() {
        return this.generatedImage;
    }
}

