/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.graphic;

import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;

public class PentaBShape
implements UDrawable {
    private final double width;
    private final double height;
    private final Fashion context;
    private final double delta = 12.0;

    private PentaBShape(double width, double height, Fashion context) {
        this.width = width;
        this.height = height;
        this.context = context;
    }

    public static PentaBShape create(double width, double height, Fashion context) {
        return new PentaBShape(width, height, context);
    }

    @Override
    public void drawU(UGraphic ug) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(12.0, 0.0);
        polygon.addPoint(this.width, 0.0);
        polygon.addPoint(this.width, this.height);
        polygon.addPoint(12.0, this.height);
        polygon.addPoint(0.0, this.height / 2.0);
        this.context.withForeColor(this.context.getBackColor()).apply(ug).draw(polygon);
        UPath path = UPath.none();
        path.moveTo(this.width, 0.0);
        path.lineTo(12.0, 0.0);
        path.lineTo(0.0, this.height / 2.0);
        path.lineTo(12.0, this.height);
        path.lineTo(this.width, this.height);
        this.context.apply(ug).draw(path);
    }
}

