/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;

public class Highlighted {
    public static final String HIGHLIGHTED = "#highlight ";
    private static final Pattern pattern = Pattern.compile("^([^<>]+)(\\<\\<.*\\>\\>)?$");
    private final List<String> paths;
    private final Stereotype stereotype;

    private Highlighted(List<String> paths, Stereotype stereotype) {
        this.paths = paths;
        this.stereotype = stereotype;
    }

    public static boolean matchesDefinition(String line) {
        return line.startsWith(HIGHLIGHTED);
    }

    public static Highlighted build(String line) {
        if (!Highlighted.matchesDefinition(line)) {
            throw new IllegalStateException();
        }
        Matcher matcher = pattern.matcher(line = line.substring(HIGHLIGHTED.length()).trim());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String paths = matcher.group(1).trim();
        Stereotype stereotype = matcher.group(2) == null ? null : Stereotype.build(matcher.group(2));
        return new Highlighted(Highlighted.toList(paths), stereotype);
    }

    private static List<String> toList(String paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : paths.split("/")) {
            result.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2.trim(), "\""));
        }
        return result;
    }

    public Highlighted upOneLevel(String key) {
        if (this.paths.size() <= 1) {
            return null;
        }
        String first = this.paths.get(0);
        if ("**".equals(first)) {
            return new Highlighted(this.paths, this.stereotype);
        }
        if ("*".equals(first) || first.equals(key)) {
            return new Highlighted(this.paths.subList(1, this.paths.size()), this.stereotype);
        }
        return null;
    }

    public boolean isKeyHighlight(String key) {
        if (this.paths.size() == 2 && this.paths.get(0).equals("**") && this.paths.get(1).equals(key)) {
            return true;
        }
        return this.paths.size() == 1 && this.paths.get(0).equals(key);
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }
}

