/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.inline;

import java.util.Set;
import java.util.regex.Pattern;
import znaishaded.org.commonmark.node.HardLineBreak;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.parser.beta.InlineContentParser;
import znaishaded.org.commonmark.parser.beta.InlineContentParserFactory;
import znaishaded.org.commonmark.parser.beta.InlineParserState;
import znaishaded.org.commonmark.parser.beta.ParsedInline;
import znaishaded.org.commonmark.parser.beta.Scanner;

public class BackslashInlineParser
implements InlineContentParser {
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        char next = scanner.peek();
        if (next == '\n') {
            scanner.next();
            return ParsedInline.of(new HardLineBreak(), scanner.position());
        }
        if (ESCAPABLE.matcher(String.valueOf(next)).matches()) {
            scanner.next();
            return ParsedInline.of(new Text(String.valueOf(next)), scanner.position());
        }
        return ParsedInline.of(new Text("\\"), scanner.position());
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Set.of(Character.valueOf('\\'));
        }

        @Override
        public InlineContentParser create() {
            return new BackslashInlineParser();
        }
    }
}

