/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.plugin;

import java.nio.file.Path;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.Doxygen;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMembersList;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenDocIncludePlugin;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenDocParamsIncludePlugin;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenMemberListExtractor;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class DoxygenMemberIncludePlugin
implements IncludePlugin {
    private Boolean disableAnchor;
    private DoxygenMembersList membersList;
    private ComponentsRegistry componentsRegistry;
    private ParserHandler parserHandler;
    private Path markupPath;
    private String fullName;
    private PluginParamsOpts paramsOpts;

    @Override
    public String id() {
        return "doxygen-member";
    }

    @Override
    public IncludePlugin create() {
        return DoxygenMemberIncludePlugin.createMemberPlugin();
    }

    public static IncludePlugin createMemberPlugin() {
        return new DoxygenMemberIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.componentsRegistry = componentsRegistry;
        this.parserHandler = parserHandler;
        this.markupPath = markupPath;
        this.paramsOpts = pluginParams.getOpts();
        this.fullName = pluginParams.getFreeParam();
        this.membersList = DoxygenMemberListExtractor.extract(Doxygen.INSTANCE, componentsRegistry, this.paramsOpts, true, this.fullName);
        if (this.membersList.isEmpty()) {
            DoxygenMemberListExtractor.throwIfMembersListIsEmpty(Doxygen.INSTANCE, componentsRegistry, this.fullName);
        }
        this.disableAnchor = this.paramsOpts.get("disableAnchor", false);
        if (this.paramsOpts.get("signatureOnly", false).booleanValue()) {
            return this.signatureOnly();
        }
        return this.fullDefinition();
    }

    private PluginResult signatureOnly() {
        this.membersList.forEach(this::memberAnchorAndSignature);
        return PluginResult.empty();
    }

    private PluginResult fullDefinition() {
        this.membersList.forEach(this::fullDefinition);
        return PluginResult.empty();
    }

    private void fullDefinition(DoxygenMember member) {
        this.memberAnchorAndSignature(member);
        DoxygenDescription description = member.getDescription();
        boolean hasParametersDesc = description.getFull() != null && description.getFull().getApiParameters() != null;
        boolean hasTemplateParametersDesc = description.getFull() != null && description.getFull().getApiTemplateParameters() != null;
        IncludePlugin docPlugin = DoxygenDocIncludePlugin.createDocPlugin();
        this.parserHandler.onIncludePlugin(docPlugin, docPlugin.process(this.componentsRegistry, this.parserHandler, this.markupPath, this.componentsRegistry.pluginParamsFactory().create(docPlugin.id(), this.fullName, this.paramsOpts.toMap())));
        if (hasParametersDesc) {
            this.parameters("", hasTemplateParametersDesc ? "parameters" : "");
        }
        if (hasTemplateParametersDesc) {
            this.parameters("template", hasParametersDesc ? "template parameters" : "");
        }
    }

    private void parameters(String type, String title) {
        IncludePlugin docParamsPlugin = DoxygenDocParamsIncludePlugin.createDocParamsPlugin();
        Map<String, Object> paramsOpts = this.paramsOpts.toMap();
        paramsOpts.put("small", true);
        paramsOpts.put("type", type);
        if (!title.isEmpty()) {
            paramsOpts.put("title", title);
        }
        this.parserHandler.onIncludePlugin(docParamsPlugin, docParamsPlugin.process(this.componentsRegistry, this.parserHandler, this.markupPath, this.componentsRegistry.pluginParamsFactory().create(docParamsPlugin.id(), this.fullName, paramsOpts)));
    }

    private void memberAnchorAndSignature(DoxygenMember member) {
        if (!this.disableAnchor.booleanValue()) {
            this.parserHandler.onGlobalAnchor(member.getId());
        }
        this.parserHandler.onCustomNode("DoxygenMember", member.toMap());
    }
}

